/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.api.PulsarClientException;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ConsumeBaseExceptionTest
extends ProducerConsumerBase {
    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        this.producerBaseSetup();
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testClosedConsumer() throws PulsarClientException {
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns/topicName"}).subscriptionName("my-subscription").subscribe();
        consumer.close();
        Assert.assertTrue((boolean)consumer.receiveAsync().isCompletedExceptionally());
        try {
            ((CompletableFuture)consumer.receiveAsync().exceptionally(e -> {
                Assert.assertTrue((boolean)(e instanceof PulsarClientException.AlreadyClosedException));
                return null;
            })).get();
        }
        catch (Exception e2) {
            Assert.fail();
        }
    }

    @Test
    public void testListener() throws PulsarClientException {
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://my-property/my-ns/topicName"}).subscriptionName("my-subscription").messageListener((MessageListener & Serializable)(consumer1, msg) -> {}).subscribe();
        Assert.assertTrue((boolean)consumer.receiveAsync().isCompletedExceptionally());
        try {
            ((CompletableFuture)consumer.receiveAsync().exceptionally(e -> {
                Assert.assertTrue((boolean)(e instanceof PulsarClientException.InvalidConfigurationException));
                return null;
            })).get();
        }
        catch (Exception e2) {
            Assert.fail();
        }
    }
}

