/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import org.apache.bookkeeper.test.PortManager;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.MockBrokerService;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ConsumerUnsubscribeTest {
    MockBrokerService mockBrokerService;
    private static final int WEB_SERVICE_PORT = PortManager.nextFreePort();
    private static final int WEB_SERVICE_TLS_PORT = PortManager.nextFreePort();
    private static final int BROKER_SERVICE_PORT = PortManager.nextFreePort();
    private static final int BROKER_SERVICE_TLS_PORT = PortManager.nextFreePort();

    @BeforeClass
    public void setup() {
        this.mockBrokerService = new MockBrokerService(WEB_SERVICE_PORT, WEB_SERVICE_TLS_PORT, BROKER_SERVICE_PORT, BROKER_SERVICE_TLS_PORT);
        this.mockBrokerService.start();
    }

    @AfterClass
    public void teardown() {
        this.mockBrokerService.stop();
    }

    @Test
    public void testConsumerUnsubscribeReference() throws Exception {
        PulsarClientImpl client = (PulsarClientImpl)PulsarClient.builder().serviceUrl("pulsar://127.0.0.1:" + BROKER_SERVICE_PORT).build();
        Consumer consumer = client.newConsumer().topic(new String[]{"persistent://public/default/t1"}).subscriptionName("sub1").subscribe();
        consumer.unsubscribe();
        Assert.assertEquals((int)client.consumersCount(), (int)0);
        client.close();
    }
}

