/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.Collections;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.bookkeeper.mledger.ManagedLedgerFactory;
import org.apache.pulsar.broker.ManagedLedgerClientFactory;
import org.apache.pulsar.broker.service.BrokerBkEnsemblesTests;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.naming.TopicName;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SequenceIdWithErrorTest
extends BrokerBkEnsemblesTests {
    @Test
    public void testCheckSequenceId() throws Exception {
        int i;
        this.admin.namespaces().createNamespace("prop/my-test", Collections.singleton("usc"));
        String topicName = "prop/my-test/my-topic";
        int N = 10;
        PulsarClient client = PulsarClient.builder().serviceUrl("pulsar://localhost:" + BROKER_SERVICE_PORT).build();
        Consumer consumer = client.newConsumer(Schema.STRING).topic(new String[]{topicName}).subscriptionName("sub").subscribe();
        ManagedLedgerClientFactory clientFactory = new ManagedLedgerClientFactory(this.pulsar.getConfiguration(), this.pulsar.getZkClient(), this.pulsar.getBookKeeperClientFactory());
        ManagedLedgerFactory mlFactory = clientFactory.getManagedLedgerFactory();
        ManagedLedger ml = mlFactory.open(TopicName.get((String)topicName).getPersistenceNamingEncoding());
        ml.close();
        clientFactory.close();
        Producer producer = client.newProducer(Schema.STRING).topic(topicName).create();
        for (i = 0; i < N; ++i) {
            producer.send((Object)("Hello-" + i));
        }
        for (i = 0; i < N; ++i) {
            Message msg = consumer.receive();
            Assert.assertEquals((String)((String)msg.getValue()), (String)("Hello-" + i));
            Assert.assertEquals((long)msg.getSequenceId(), (long)i);
            consumer.acknowledge(msg);
        }
        client.close();
    }

    @Override
    @Test(enabled=false)
    public void testCrashBrokerWithoutCursorLedgerLeak() throws Exception {
    }

    @Override
    @Test(enabled=false)
    public void testSkipCorruptDataLedger() throws Exception {
    }
}

