/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.service.BrokerTestBase;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageListener;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.ConsumerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ZeroQueueSizeTest
extends BrokerTestBase {
    private static final Logger log = LoggerFactory.getLogger(ZeroQueueSizeTest.class);
    private final int totalMessages = 10;

    @Override
    @BeforeClass
    public void setup() throws Exception {
        this.baseSetup();
    }

    @Override
    @AfterClass
    protected void cleanup() throws Exception {
        this.internalCleanup();
    }

    @Test
    public void validQueueSizeConfig() {
        this.pulsarClient.newConsumer().receiverQueueSize(0);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void InvalidQueueSizeConfig() {
        this.pulsarClient.newConsumer().receiverQueueSize(-1);
    }

    @Test(expectedExceptions={PulsarClientException.InvalidConfigurationException.class})
    public void zeroQueueSizeReceieveAsyncInCompatibility() throws PulsarClientException {
        String key = "zeroQueueSizeReceieveAsyncInCompatibility";
        String topicName = "persistent://prop/use/ns-abc/topic-" + key;
        String subscriptionName = "my-ex-subscription-" + key;
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).subscribe();
        consumer.receive(10, TimeUnit.SECONDS);
    }

    @Test(expectedExceptions={PulsarClientException.class})
    public void zeroQueueSizePartitionedTopicInCompatibility() throws PulsarClientException, PulsarAdminException {
        String key = "zeroQueueSizePartitionedTopicInCompatibility";
        String topicName = "persistent://prop/use/ns-abc/topic-" + key;
        String subscriptionName = "my-ex-subscription-" + key;
        int numberOfPartitions = 3;
        this.admin.topics().createPartitionedTopic(topicName, numberOfPartitions);
        this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).subscribe();
    }

    @Test
    public void zeroQueueSizeNormalConsumer() throws PulsarClientException {
        String key = "nonZeroQueueSizeNormalConsumer";
        String topicName = "persistent://prop/use/ns-abc/topic-" + key;
        String subscriptionName = "my-ex-subscription-" + key;
        String messagePredicate = "my-message-" + key + "-";
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        ConsumerImpl consumer = (ConsumerImpl)this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).subscribe();
        for (int i = 0; i < 10; ++i) {
            String message = messagePredicate + i;
            log.info("Producer produced: " + message);
            producer.send((Object)message.getBytes());
        }
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((int)consumer.numMessagesInQueue(), (int)0);
            Message message = consumer.receive();
            Assert.assertEquals((String)new String(message.getData()), (String)(messagePredicate + i));
            Assert.assertEquals((int)consumer.numMessagesInQueue(), (int)0);
            log.info("Consumer received : " + new String(message.getData()));
        }
    }

    @Test
    public void zeroQueueSizeConsumerListener() throws Exception {
        int i;
        String key = "zeroQueueSizeConsumerListener";
        String topicName = "persistent://prop/use/ns-abc/topic-" + key;
        String subscriptionName = "my-ex-subscription-" + key;
        String messagePredicate = "my-message-" + key + "-";
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        ArrayList messages = Lists.newArrayList();
        CountDownLatch latch = new CountDownLatch(10);
        ConsumerImpl consumer = (ConsumerImpl)this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).messageListener((MessageListener & Serializable)(cons, msg) -> {
            Assert.assertEquals((int)((ConsumerImpl)cons).numMessagesInQueue(), (int)0);
            List list = messages;
            synchronized (list) {
                messages.add(msg);
            }
            log.info("Consumer received: " + new String(msg.getData()));
            latch.countDown();
        }).subscribe();
        for (i = 0; i < 10; ++i) {
            String message = messagePredicate + i;
            log.info("Producer produced: " + message);
            producer.send((Object)message.getBytes());
        }
        latch.await();
        Assert.assertEquals((int)consumer.numMessagesInQueue(), (int)0);
        Assert.assertEquals((int)messages.size(), (int)10);
        for (i = 0; i < messages.size(); ++i) {
            Assert.assertEquals((String)new String(((Message)messages.get(i)).getData()), (String)(messagePredicate + i));
        }
    }

    @Test
    public void zeroQueueSizeSharedSubscription() throws PulsarClientException {
        int i;
        String key = "zeroQueueSizeSharedSubscription";
        String topicName = "persistent://prop/use/ns-abc/topic-" + key;
        String subscriptionName = "my-ex-subscription-" + key;
        String messagePredicate = "my-message-" + key + "-";
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        int numOfSubscribers = 4;
        ConsumerImpl[] consumers = new ConsumerImpl[numOfSubscribers];
        for (i = 0; i < numOfSubscribers; ++i) {
            consumers[i] = (ConsumerImpl)this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).subscriptionType(SubscriptionType.Shared).subscribe();
        }
        for (i = 0; i < 10; ++i) {
            String message = messagePredicate + i;
            producer.send((Object)message.getBytes());
        }
        for (int i2 = 0; i2 < 10; ++i2) {
            Assert.assertEquals((int)consumers[i2 % numOfSubscribers].numMessagesInQueue(), (int)0);
            Message message = consumers[i2 % numOfSubscribers].receive();
            Assert.assertEquals((String)new String(message.getData()), (String)(messagePredicate + i2));
            Assert.assertEquals((int)consumers[i2 % numOfSubscribers].numMessagesInQueue(), (int)0);
            log.info("Consumer received : " + new String(message.getData()));
        }
    }

    @Test
    public void zeroQueueSizeFailoverSubscription() throws PulsarClientException {
        int i;
        String key = "zeroQueueSizeFailoverSubscription";
        String topicName = "persistent://prop/use/ns-abc/topic-" + key;
        String subscriptionName = "my-ex-subscription-" + key;
        String messagePredicate = "my-message-" + key + "-";
        Producer producer = this.pulsarClient.newProducer().topic(topicName).enableBatching(false).messageRoutingMode(MessageRoutingMode.SinglePartition).create();
        ConsumerImpl consumer1 = (ConsumerImpl)this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).subscriptionType(SubscriptionType.Failover).consumerName("consumer-1").subscribe();
        ConsumerImpl consumer2 = (ConsumerImpl)this.pulsarClient.newConsumer().topic(new String[]{topicName}).subscriptionName(subscriptionName).receiverQueueSize(0).subscriptionType(SubscriptionType.Failover).consumerName("consumer-2").subscribe();
        for (int i2 = 0; i2 < 10; ++i2) {
            String message = messagePredicate + i2;
            producer.send((Object)message.getBytes());
        }
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((int)consumer1.numMessagesInQueue(), (int)0);
            Message message = consumer1.receive();
            Assert.assertEquals((String)new String(message.getData()), (String)(messagePredicate + i));
            Assert.assertEquals((int)consumer1.numMessagesInQueue(), (int)0);
            log.info("Consumer received : " + new String(message.getData()));
        }
        consumer1.redeliverUnacknowledgedMessages();
        consumer1.close();
        for (i = 0; i < 5; ++i) {
            Assert.assertEquals((int)consumer2.numMessagesInQueue(), (int)0);
            Message message = consumer2.receive();
            Assert.assertEquals((String)new String(message.getData()), (String)(messagePredicate + i));
            Assert.assertEquals((int)consumer2.numMessagesInQueue(), (int)0);
            log.info("Consumer received : " + new String(message.getData()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedZeroQueueSizeBatchMessage() throws PulsarClientException {
        int batchMessageDelayMs = 100;
        Consumer consumer = this.pulsarClient.newConsumer().topic(new String[]{"persistent://prop-xyz/use/ns-abc/topic1"}).subscriptionName("my-subscriber-name").subscriptionType(SubscriptionType.Shared).receiverQueueSize(0).subscribe();
        ProducerBuilder producerBuilder = this.pulsarClient.newProducer().topic("persistent://prop-xyz/use/ns-abc/topic1").messageRoutingMode(MessageRoutingMode.SinglePartition);
        if (batchMessageDelayMs != 0) {
            producerBuilder.enableBatching(true).batchingMaxPublishDelay((long)batchMessageDelayMs, TimeUnit.MILLISECONDS).batchingMaxMessages(5);
        } else {
            producerBuilder.enableBatching(false);
        }
        Producer producer = producerBuilder.create();
        for (int i = 0; i < 10; ++i) {
            String message = "my-message-" + i;
            producer.send((Object)message.getBytes());
        }
        try {
            consumer.receiveAsync().handle((ok, e) -> {
                if (e == null) {
                    Assert.fail();
                }
                return null;
            });
        }
        finally {
            consumer.close();
        }
    }
}

