/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.cache.LocalZooKeeperCacheService;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleFactory;
import org.apache.pulsar.common.naming.NamespaceBundles;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.zookeeper.ZooKeeperCacheListener;
import org.apache.pulsar.zookeeper.ZooKeeperDataCache;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NamespaceBundleTest {
    private final NamespaceBundleFactory factory = this.getNamespaceBundleFactory();

    @Test
    public void testConstructor() {
        try {
            new NamespaceBundle(null, null, null);
            Assert.fail((String)"Should have failed w/ null pointer exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            new NamespaceBundle(NamespaceName.get((String)"pulsar.old.ns"), null, null);
            Assert.fail((String)"Should have failed w/ illegal argument exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new NamespaceBundle(NamespaceName.get((String)"pulsar/use/ns"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0L), (BoundType)BoundType.OPEN), null);
            Assert.fail((String)"Should have failed w/ illegal argument exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new NamespaceBundle(NamespaceName.get((String)"pulsar/use/ns"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.OPEN, (Comparable)Long.valueOf(1L), (BoundType)BoundType.OPEN), null);
            Assert.fail((String)"Should have failed w/ illegal argument exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new NamespaceBundle(NamespaceName.get((String)"pulsar/use/ns"), Range.range((Comparable)Long.valueOf(1L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(1L), (BoundType)BoundType.OPEN), null);
            Assert.fail((String)"Should have failed w/ illegal argument exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new NamespaceBundle(NamespaceName.get((String)"pulsar/use/ns"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(1L), (BoundType)BoundType.CLOSED), null);
            Assert.fail((String)"Should have failed w/ illegal argument exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new NamespaceBundle(NamespaceName.get((String)"pulsar/use/ns"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)NamespaceBundles.FULL_UPPER_BOUND, (BoundType)BoundType.OPEN), null);
            Assert.fail((String)"Should have failed w/ illegal argument exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new NamespaceBundle(NamespaceName.get((String)"pulsar/use/ns"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)NamespaceBundles.FULL_UPPER_BOUND, (BoundType)BoundType.CLOSED), null);
            Assert.fail((String)"Should have failed w/ null pointer exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        NamespaceBundle bundle = new NamespaceBundle(NamespaceName.get((String)"pulsar/use/ns"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(1L), (BoundType)BoundType.OPEN), this.factory);
        Assert.assertEquals((long)((Long)bundle.getKeyRange().lowerEndpoint()), (long)0L);
        Assert.assertEquals((Object)bundle.getKeyRange().lowerBoundType(), (Object)BoundType.CLOSED);
        Assert.assertEquals((long)((Long)bundle.getKeyRange().upperEndpoint()), (long)1L);
        Assert.assertEquals((Object)bundle.getKeyRange().upperBoundType(), (Object)BoundType.OPEN);
        Assert.assertEquals((String)bundle.getNamespaceObject().toString(), (String)"pulsar/use/ns");
    }

    private NamespaceBundleFactory getNamespaceBundleFactory() {
        PulsarService pulsar = (PulsarService)Mockito.mock(PulsarService.class);
        LocalZooKeeperCacheService localZkCache = (LocalZooKeeperCacheService)Mockito.mock(LocalZooKeeperCacheService.class);
        ZooKeeperDataCache poilciesCache = (ZooKeeperDataCache)Mockito.mock(ZooKeeperDataCache.class);
        Mockito.when((Object)pulsar.getLocalZkCacheService()).thenReturn((Object)localZkCache);
        Mockito.when((Object)localZkCache.policiesCache()).thenReturn((Object)poilciesCache);
        ((ZooKeeperDataCache)Mockito.doNothing().when((Object)poilciesCache)).registerListener((ZooKeeperCacheListener)Mockito.any());
        return NamespaceBundleFactory.createFactory((PulsarService)pulsar, (HashFunction)Hashing.crc32());
    }

    @Test
    public void testGetBundle() throws Exception {
        NamespaceBundle bundle = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns1"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0xFFFFFFFFL), (BoundType)BoundType.CLOSED));
        Assert.assertNotNull((Object)bundle);
        NamespaceBundle bundle2 = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns1"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0xFFFFFFFFL), (BoundType)BoundType.CLOSED));
        Assert.assertEquals((Object)bundle, (Object)bundle2);
    }

    @Test
    public void testCompareTo() throws Exception {
        NamespaceBundle bundle = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns1"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x40000000L), (BoundType)BoundType.OPEN));
        NamespaceBundle bundle2 = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns1"), Range.range((Comparable)Long.valueOf(0x20000000L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x40000000L), (BoundType)BoundType.OPEN));
        try {
            bundle.compareTo(bundle2);
            Assert.fail((String)"Should have failed due to overlap ranges");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        NamespaceBundle bundle0 = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns1"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x10000000L), (BoundType)BoundType.OPEN));
        Assert.assertTrue((bundle0.compareTo(bundle2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((bundle2.compareTo(bundle0) > 0 ? 1 : 0) != 0);
        NamespaceBundle bundle1 = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns1"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x20000000L), (BoundType)BoundType.OPEN));
        Assert.assertTrue((bundle1.compareTo(bundle2) < 0 ? 1 : 0) != 0);
        NamespaceBundle bundle3 = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns1"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x40000000L), (BoundType)BoundType.OPEN));
        Assert.assertEquals((int)bundle.compareTo(bundle3), (int)0);
        NamespaceBundle otherBundle = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns2"), Range.range((Comparable)Long.valueOf(0x10000000L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x30000000L), (BoundType)BoundType.OPEN));
        Assert.assertTrue((otherBundle.compareTo(bundle0) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() throws Exception {
        NamespaceBundle bundle = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns1"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x40000000L), (BoundType)BoundType.OPEN));
        NamespaceBundle bundle2 = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns1"), Range.range((Comparable)Long.valueOf(0x20000000L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x40000000L), (BoundType)BoundType.OPEN));
        Assert.assertNotEquals((Object)bundle2, (Object)bundle);
        NamespaceBundle bundle0 = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns1"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x40000000L), (BoundType)BoundType.OPEN));
        Assert.assertEquals((Object)bundle, (Object)bundle0);
        NamespaceBundle otherBundle = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns2"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x40000000L), (BoundType)BoundType.OPEN));
        Assert.assertNotEquals((Object)bundle, (Object)otherBundle);
    }

    @Test
    public void testIncludes() throws Exception {
        TopicName topicName = TopicName.get((String)"persistent://pulsar/use/ns1/topic-1");
        Long hashKey = this.factory.getLongHashCode(topicName.toString());
        Long upper = Math.max(hashKey + 1L, NamespaceBundles.FULL_UPPER_BOUND);
        BoundType upperType = upper.equals(NamespaceBundles.FULL_UPPER_BOUND) ? BoundType.CLOSED : BoundType.OPEN;
        NamespaceBundle bundle = this.factory.getBundle(topicName.getNamespaceObject(), Range.range((Comparable)Long.valueOf(hashKey / 2L), (BoundType)BoundType.CLOSED, (Comparable)upper, (BoundType)upperType));
        Assert.assertTrue((boolean)bundle.includes(topicName));
        bundle = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns1"), Range.range((Comparable)upper, (BoundType)BoundType.CLOSED, (Comparable)NamespaceBundles.FULL_UPPER_BOUND, (BoundType)BoundType.CLOSED));
        Assert.assertFalse((boolean)bundle.includes(topicName));
        NamespaceBundle otherBundle = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns2"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x40000000L), (BoundType)BoundType.OPEN));
        Assert.assertFalse((boolean)otherBundle.includes(topicName));
    }

    @Test
    public void testToString() throws Exception {
        NamespaceBundle bundle0 = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns1"), Range.range((Comparable)Long.valueOf(0L), (BoundType)BoundType.CLOSED, (Comparable)Long.valueOf(0x10000000L), (BoundType)BoundType.OPEN));
        Assert.assertEquals((String)bundle0.toString(), (String)"pulsar/use/ns1/0x00000000_0x10000000");
        bundle0 = this.factory.getBundle(NamespaceName.get((String)"pulsar/use/ns1"), Range.range((Comparable)Long.valueOf(0x10000000L), (BoundType)BoundType.CLOSED, (Comparable)NamespaceBundles.FULL_UPPER_BOUND, (BoundType)BoundType.CLOSED));
        Assert.assertEquals((String)bundle0.toString(), (String)"pulsar/use/ns1/0x10000000_0xffffffff");
    }
}

