/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.naming;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.common.configuration.PulsarConfigurationLoader;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ServiceConfigurationTest {
    final String fileName = "configurations/pulsar_broker_test.conf";

    @Test
    public void testInit() throws Exception {
        String zookeeperServer = "localhost:2184";
        int brokerServicePort = 1000;
        InputStream newStream = this.updateProp("localhost:2184", String.valueOf(1000), "ns1,ns2");
        ServiceConfiguration config = (ServiceConfiguration)PulsarConfigurationLoader.create((InputStream)newStream, ServiceConfiguration.class);
        Assert.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)config.getZookeeperServers()));
        Assert.assertTrue((config.getBrokerServicePort().isPresent() && ((Integer)config.getBrokerServicePort().get()).equals(1000) ? 1 : 0) != 0);
        Assert.assertEquals((String)((String)config.getBootstrapNamespaces().get(1)), (String)"ns2");
    }

    @Test
    public void testOptionalSettingEmpty() throws Exception {
        String confFile = "loadBalancerOverrideBrokerNicSpeedGbps=\n";
        ByteArrayInputStream stream = new ByteArrayInputStream(confFile.getBytes());
        ServiceConfiguration config = (ServiceConfiguration)PulsarConfigurationLoader.create((InputStream)stream, ServiceConfiguration.class);
        Assert.assertEquals((Object)config.getLoadBalancerOverrideBrokerNicSpeedGbps(), Optional.empty());
    }

    @Test
    public void testOptionalSettingPresent() throws Exception {
        String confFile = "loadBalancerOverrideBrokerNicSpeedGbps=5\n";
        ByteArrayInputStream stream = new ByteArrayInputStream(confFile.getBytes());
        ServiceConfiguration config = (ServiceConfiguration)PulsarConfigurationLoader.create((InputStream)stream, ServiceConfiguration.class);
        Assert.assertEquals((Object)config.getLoadBalancerOverrideBrokerNicSpeedGbps(), Optional.of(5.0));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testInitFailure() throws Exception {
        String zookeeperServer = "localhost:2184";
        InputStream newStream = this.updateProp("localhost:2184", String.valueOf("invalid-string"), null);
        PulsarConfigurationLoader.create((InputStream)newStream, ServiceConfiguration.class);
    }

    private InputStream updateProp(String zookeeperServer, String brokerServicePort, String namespace) throws IOException {
        Preconditions.checkNotNull((Object)"configurations/pulsar_broker_test.conf");
        Properties properties = new Properties();
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("configurations/pulsar_broker_test.conf");
        properties.load(stream);
        properties.setProperty("zookeeperServers", zookeeperServer);
        properties.setProperty("brokerServicePort", brokerServicePort);
        if (namespace != null) {
            properties.setProperty("bootstrapNamespaces", namespace);
        }
        StringWriter writer = new StringWriter();
        properties.list(new PrintWriter(writer));
        return new ByteArrayInputStream(writer.toString().getBytes(StandardCharsets.UTF_8));
    }
}

