/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.discovery.service.web;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.apache.bookkeeper.test.PortManager;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.discovery.service.server.ServerManager;
import org.apache.pulsar.discovery.service.server.ServiceConfig;
import org.apache.pulsar.discovery.service.web.DiscoveryServiceServlet;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.zookeeper.ZooKeeper;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.logging.LoggingFeature;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DiscoveryServiceWebTest
extends ProducerConsumerBase {
    private Client client = ClientBuilder.newClient((Configuration)new ClientConfig().register(LoggingFeature.class));

    @Override
    @BeforeMethod
    protected void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @Test
    public void testRedirectUrlWithServerStarted() throws Exception {
        int port = PortManager.nextFreePort();
        ServiceConfig config = new ServiceConfig();
        config.setWebServicePort(Optional.of(port));
        ServerManager server = new ServerManager(config);
        DiscoveryZooKeeperClientFactoryImpl.zk = this.mockZookKeeper;
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("zookeeperServers", "");
        params.put("zookeeperClientFactoryClass", DiscoveryZooKeeperClientFactoryImpl.class.getName());
        server.addServlet("/", DiscoveryServiceServlet.class, params);
        server.start();
        String serviceUrl = server.getServiceUri().toString();
        String putRequestUrl = serviceUrl + "admin/v2/namespaces/p1/n1";
        String postRequestUrl = serviceUrl + "admin/v2/namespaces/p1/n1/replication";
        String getRequestUrl = serviceUrl + "admin/v2/namespaces/p1";
        Assert.assertEquals((String)this.hitBrokerService("POST", postRequestUrl, Lists.newArrayList((Object[])new String[]{"use"})), (String)"Tenant does not exist");
        Assert.assertEquals((String)this.hitBrokerService("PUT", putRequestUrl, new BundlesData(1)), (String)"Tenant does not exist");
        Assert.assertEquals((String)this.hitBrokerService("GET", getRequestUrl, null), (String)"Tenant does not exist");
        server.stop();
    }

    public String hitBrokerService(String method, String url, Object data) throws JsonParseException {
        Response response = null;
        try {
            WebTarget webTarget = this.client.target(url);
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
            if ("PUT".equals(method)) {
                response = invocationBuilder.put(Entity.entity((Object)data, (String)"application/json"));
            } else if ("GET".equals(method)) {
                response = invocationBuilder.get();
            } else if ("POST".equals(method)) {
                response = invocationBuilder.post(Entity.entity((Object)data, (String)"application/json"));
            } else {
                Assert.fail((String)"Unsupported http method");
            }
        }
        catch (Exception e) {
            Assert.fail();
        }
        JsonObject jsonObject = (JsonObject)new Gson().fromJson((String)response.readEntity(String.class), JsonObject.class);
        String serviceResponse = jsonObject.get("reason").getAsString();
        return serviceResponse;
    }

    static class DiscoveryZooKeeperClientFactoryImpl
    implements ZooKeeperClientFactory {
        static ZooKeeper zk;

        DiscoveryZooKeeperClientFactoryImpl() {
        }

        public CompletableFuture<ZooKeeper> create(String serverList, ZooKeeperClientFactory.SessionType sessionType, int zkSessionTimeoutMillis) {
            return CompletableFuture.completedFuture(zk);
        }
    }
}

