/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.test.PortManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.ServiceConfigurationUtils;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.authentication.AuthenticationProviderTls;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.broker.loadbalance.impl.SimpleLoadManagerImpl;
import org.apache.pulsar.client.admin.BrokerStats;
import org.apache.pulsar.client.admin.PulsarAdmin;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.ClientBuilder;
import org.apache.pulsar.client.api.Consumer;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.auth.AuthenticationTls;
import org.apache.pulsar.common.functions.ConsumerConfig;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.io.SinkConfig;
import org.apache.pulsar.common.io.SourceConfig;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.ConsumerStats;
import org.apache.pulsar.common.policies.data.PublisherStats;
import org.apache.pulsar.common.policies.data.SubscriptionStats;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.functions.LocalRunner;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.scheduler.RoundRobinScheduler;
import org.apache.pulsar.io.datagenerator.DataGeneratorPrintSink;
import org.apache.pulsar.io.datagenerator.DataGeneratorSource;
import org.apache.pulsar.zookeeper.LocalBookkeeperEnsemble;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class PulsarFunctionLocalRunTest {
    LocalBookkeeperEnsemble bkEnsemble;
    ServiceConfiguration config;
    WorkerConfig workerConfig;
    URL urlTls;
    PulsarService pulsar;
    PulsarAdmin admin;
    PulsarClient pulsarClient;
    BrokerStats brokerStatsClient;
    WorkerService functionsWorkerService;
    final String tenant = "external-repl-prop";
    String pulsarFunctionsNamespace = "external-repl-prop/pulsar-function-admin";
    String primaryHost;
    String workerId;
    private static final String CLUSTER = "local";
    private final int ZOOKEEPER_PORT = PortManager.nextFreePort();
    private final int brokerWebServicePort = PortManager.nextFreePort();
    private final int brokerWebServiceTlsPort = PortManager.nextFreePort();
    private final int brokerServicePort = PortManager.nextFreePort();
    private final int brokerServiceTlsPort = PortManager.nextFreePort();
    private final int workerServicePort = PortManager.nextFreePort();
    private final String TLS_SERVER_CERT_FILE_PATH = "./src/test/resources/authentication/tls/broker-cert.pem";
    private final String TLS_SERVER_KEY_FILE_PATH = "./src/test/resources/authentication/tls/broker-key.pem";
    private final String TLS_CLIENT_CERT_FILE_PATH = "./src/test/resources/authentication/tls/client-cert.pem";
    private final String TLS_CLIENT_KEY_FILE_PATH = "./src/test/resources/authentication/tls/client-key.pem";
    private final String TLS_TRUST_CERT_FILE_PATH = "./src/test/resources/authentication/tls/cacert.pem";
    private static final Logger log = LoggerFactory.getLogger(PulsarFunctionLocalRunTest.class);
    private Thread fileServerThread;
    private static final int fileServerPort = PortManager.nextFreePort();
    private HttpServer fileServer;

    @DataProvider(name="validRoleName")
    public Object[][] validRoleName() {
        return new Object[][]{{Boolean.TRUE}, {Boolean.FALSE}};
    }

    @BeforeMethod
    void setup(Method method) throws Exception {
        File[] foundFiles;
        File dir = new File(System.getProperty("java.io.tmpdir"));
        for (File file : foundFiles = dir.listFiles((ignoredDir, name) -> name.startsWith("function"))) {
            file.delete();
        }
        log.info("--- Setting up method {} ---", (Object)method.getName());
        this.bkEnsemble = new LocalBookkeeperEnsemble(3, this.ZOOKEEPER_PORT, () -> PortManager.nextFreePort());
        this.bkEnsemble.start();
        String brokerServiceUrl = "https://127.0.0.1:" + this.brokerWebServiceTlsPort;
        this.config = (ServiceConfiguration)Mockito.spy((Object)new ServiceConfiguration());
        this.config.setClusterName(CLUSTER);
        HashSet superUsers = Sets.newHashSet((Object[])new String[]{"superUser"});
        this.config.setSuperUserRoles((Set)superUsers);
        this.config.setWebServicePort(Optional.ofNullable(this.brokerWebServicePort));
        this.config.setWebServicePortTls(Optional.ofNullable(this.brokerWebServiceTlsPort));
        this.config.setZookeeperServers("127.0.0.1:" + this.ZOOKEEPER_PORT);
        this.config.setBrokerServicePort(Optional.ofNullable(this.brokerServicePort));
        this.config.setBrokerServicePortTls(Optional.ofNullable(this.brokerServiceTlsPort));
        this.config.setLoadManagerClassName(SimpleLoadManagerImpl.class.getName());
        this.config.setTlsAllowInsecureConnection(true);
        this.config.setAdvertisedAddress("localhost");
        HashSet<String> providers = new HashSet<String>();
        providers.add(AuthenticationProviderTls.class.getName());
        this.config.setAuthenticationEnabled(true);
        this.config.setAuthenticationProviders(providers);
        this.config.setAuthorizationEnabled(true);
        this.config.setAuthorizationProvider(PulsarAuthorizationProvider.class.getName());
        this.config.setTlsCertificateFilePath("./src/test/resources/authentication/tls/broker-cert.pem");
        this.config.setTlsKeyFilePath("./src/test/resources/authentication/tls/broker-key.pem");
        this.config.setTlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem");
        this.config.setBrokerClientAuthenticationPlugin(AuthenticationTls.class.getName());
        this.config.setBrokerClientAuthenticationParameters("tlsCertFile:./src/test/resources/authentication/tls/client-cert.pem,tlsKeyFile:./src/test/resources/authentication/tls/client-key.pem");
        this.config.setBrokerClientTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem");
        this.config.setBrokerClientTlsEnabled(true);
        this.config.setAllowAutoTopicCreationType("non-partitioned");
        this.functionsWorkerService = this.createPulsarFunctionWorker(this.config);
        this.urlTls = new URL(brokerServiceUrl);
        Optional<WorkerService> functionWorkerService = Optional.of(this.functionsWorkerService);
        this.pulsar = new PulsarService(this.config, functionWorkerService);
        this.pulsar.start();
        HashMap<String, String> authParams = new HashMap<String, String>();
        authParams.put("tlsCertFile", "./src/test/resources/authentication/tls/client-cert.pem");
        authParams.put("tlsKeyFile", "./src/test/resources/authentication/tls/client-key.pem");
        AuthenticationTls authTls = new AuthenticationTls();
        authTls.configure(authParams);
        this.admin = (PulsarAdmin)Mockito.spy((Object)PulsarAdmin.builder().serviceHttpUrl(brokerServiceUrl).tlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem").allowTlsInsecureConnection(true).authentication((Authentication)authTls).build());
        this.brokerStatsClient = this.admin.brokerStats();
        this.primaryHost = String.format("http://%s:%d", "localhost", this.brokerWebServicePort);
        ClusterData clusterData = new ClusterData(this.urlTls.toString());
        this.admin.clusters().updateCluster(this.config.getClusterName(), clusterData);
        ClientBuilder clientBuilder = PulsarClient.builder().serviceUrl(this.workerConfig.getPulsarServiceUrl());
        if (StringUtils.isNotBlank((CharSequence)this.workerConfig.getClientAuthenticationPlugin()) && StringUtils.isNotBlank((CharSequence)this.workerConfig.getClientAuthenticationParameters())) {
            clientBuilder.enableTls(this.workerConfig.isUseTls());
            clientBuilder.allowTlsInsecureConnection(this.workerConfig.isTlsAllowInsecureConnection());
            clientBuilder.authentication(this.workerConfig.getClientAuthenticationPlugin(), this.workerConfig.getClientAuthenticationParameters());
        }
        this.pulsarClient = clientBuilder.build();
        TenantInfo propAdmin = new TenantInfo();
        propAdmin.getAdminRoles().add("superUser");
        propAdmin.setAllowedClusters((Set)Sets.newHashSet((Iterable)Lists.newArrayList((Object[])new String[]{CLUSTER})));
        this.admin.tenants().updateTenant("external-repl-prop", propAdmin);
        this.fileServerThread = new Thread(() -> {
            try {
                this.fileServer = HttpServer.create(new InetSocketAddress(fileServerPort), 0);
                this.fileServer.createContext("/pulsar-io-data-generator.nar", he -> {
                    try {
                        Headers headers = he.getResponseHeaders();
                        headers.add("Content-Type", "application/octet-stream");
                        File file = new File(this.getClass().getClassLoader().getResource("pulsar-io-data-generator.nar").getFile());
                        byte[] bytes = new byte[(int)file.length()];
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        bufferedInputStream.read(bytes, 0, bytes.length);
                        he.sendResponseHeaders(200, file.length());
                        OutputStream outputStream = he.getResponseBody();
                        outputStream.write(bytes, 0, bytes.length);
                        outputStream.close();
                    }
                    catch (Exception e) {
                        log.error("Error when downloading: {}", (Object)e, (Object)e);
                    }
                });
                this.fileServer.createContext("/pulsar-functions-api-examples.jar", he -> {
                    try {
                        Headers headers = he.getResponseHeaders();
                        headers.add("Content-Type", "application/octet-stream");
                        File file = new File(this.getClass().getClassLoader().getResource("pulsar-functions-api-examples.jar").getFile());
                        byte[] bytes = new byte[(int)file.length()];
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        bufferedInputStream.read(bytes, 0, bytes.length);
                        he.sendResponseHeaders(200, file.length());
                        OutputStream outputStream = he.getResponseBody();
                        outputStream.write(bytes, 0, bytes.length);
                        outputStream.close();
                    }
                    catch (Exception e) {
                        log.error("Error when downloading: {}", (Object)e, (Object)e);
                    }
                });
                this.fileServer.setExecutor(null);
                log.info("Starting file server...");
                this.fileServer.start();
            }
            catch (Exception e) {
                log.error("Failed to start file server: ", (Throwable)e);
                this.fileServer.stop(0);
            }
        });
        this.fileServerThread.start();
    }

    @AfterMethod
    void shutdown() throws Exception {
        log.info("--- Shutting down ---");
        this.fileServer.stop(0);
        this.fileServerThread.interrupt();
        this.pulsarClient.close();
        this.admin.close();
        this.functionsWorkerService.stop();
        this.pulsar.close();
        this.bkEnsemble.stop();
    }

    private WorkerService createPulsarFunctionWorker(ServiceConfiguration config) {
        System.setProperty("pulsar.functions.java.instance.jar", FutureUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        this.workerConfig = new WorkerConfig();
        this.workerConfig.setPulsarFunctionsNamespace(this.pulsarFunctionsNamespace);
        this.workerConfig.setSchedulerClassName(RoundRobinScheduler.class.getName());
        this.workerConfig.setThreadContainerFactory(new WorkerConfig.ThreadContainerFactory().setThreadGroupName(CLUSTER));
        this.workerConfig.setPulsarServiceUrl("pulsar://127.0.0.1:" + config.getBrokerServicePortTls().get());
        this.workerConfig.setPulsarWebServiceUrl("https://127.0.0.1:" + config.getWebServicePortTls().get());
        this.workerConfig.setFailureCheckFreqMs(100L);
        this.workerConfig.setNumFunctionPackageReplicas(1);
        this.workerConfig.setClusterCoordinationTopicName("coordinate");
        this.workerConfig.setFunctionAssignmentTopicName("assignment");
        this.workerConfig.setFunctionMetadataTopicName("metadata");
        this.workerConfig.setInstanceLivenessCheckFreqMs(100L);
        this.workerConfig.setWorkerPort(Integer.valueOf(this.workerServicePort));
        this.workerConfig.setPulsarFunctionsCluster(config.getClusterName());
        String hostname = ServiceConfigurationUtils.getDefaultOrConfiguredAddress((String)config.getAdvertisedAddress());
        this.workerId = "c-" + config.getClusterName() + "-fw-" + hostname + "-" + this.workerConfig.getWorkerPort();
        this.workerConfig.setWorkerHostname(hostname);
        this.workerConfig.setWorkerId(this.workerId);
        this.workerConfig.setClientAuthenticationPlugin(AuthenticationTls.class.getName());
        this.workerConfig.setClientAuthenticationParameters(String.format("tlsCertFile:%s,tlsKeyFile:%s", "./src/test/resources/authentication/tls/client-cert.pem", "./src/test/resources/authentication/tls/client-key.pem"));
        this.workerConfig.setUseTls(true);
        this.workerConfig.setTlsAllowInsecureConnection(true);
        this.workerConfig.setTlsTrustCertsFilePath("./src/test/resources/authentication/tls/cacert.pem");
        this.workerConfig.setAuthenticationEnabled(true);
        this.workerConfig.setAuthorizationEnabled(true);
        return new WorkerService(this.workerConfig);
    }

    protected static FunctionConfig createFunctionConfig(String tenant, String namespace, String functionName, String sourceTopic, String sinkTopic, String subscriptionName) {
        FunctionConfig functionConfig = new FunctionConfig();
        functionConfig.setTenant(tenant);
        functionConfig.setNamespace(namespace);
        functionConfig.setName(functionName);
        functionConfig.setParallelism(Integer.valueOf(1));
        functionConfig.setProcessingGuarantees(FunctionConfig.ProcessingGuarantees.EFFECTIVELY_ONCE);
        functionConfig.setSubName(subscriptionName);
        functionConfig.setInputs(Collections.singleton(sourceTopic));
        functionConfig.setAutoAck(Boolean.valueOf(true));
        functionConfig.setClassName("org.apache.pulsar.functions.api.examples.ExclamationFunction");
        functionConfig.setRuntime(FunctionConfig.Runtime.JAVA);
        functionConfig.setOutput(sinkTopic);
        functionConfig.setCleanupSubscription(Boolean.valueOf(true));
        return functionConfig;
    }

    private static SourceConfig createSourceConfig(String tenant, String namespace, String functionName, String sinkTopic) {
        SourceConfig sourceConfig = new SourceConfig();
        sourceConfig.setTenant(tenant);
        sourceConfig.setNamespace(namespace);
        sourceConfig.setName(functionName);
        sourceConfig.setParallelism(Integer.valueOf(1));
        sourceConfig.setProcessingGuarantees(FunctionConfig.ProcessingGuarantees.ATLEAST_ONCE);
        sourceConfig.setTopicName(sinkTopic);
        return sourceConfig;
    }

    private static SinkConfig createSinkConfig(String tenant, String namespace, String functionName, String sourceTopic, String subName) {
        SinkConfig sinkConfig = new SinkConfig();
        sinkConfig.setTenant(tenant);
        sinkConfig.setNamespace(namespace);
        sinkConfig.setName(functionName);
        sinkConfig.setParallelism(Integer.valueOf(1));
        sinkConfig.setProcessingGuarantees(FunctionConfig.ProcessingGuarantees.ATLEAST_ONCE);
        sinkConfig.setInputSpecs(Collections.singletonMap(sourceTopic, ConsumerConfig.builder().build()));
        sinkConfig.setSourceSubscriptionName(subName);
        sinkConfig.setCleanupSubscription(Boolean.valueOf(true));
        return sinkConfig;
    }

    private void testE2EPulsarFunctionLocalRun(String jarFilePathUrl) throws Exception {
        block4: {
            int i;
            String namespacePortion = "io";
            String replNamespace = "external-repl-prop/io";
            String sourceTopic = "persistent://external-repl-prop/io/my-topic1";
            String sinkTopic = "persistent://external-repl-prop/io/output";
            String propertyKey = "key";
            String propertyValue = "value";
            String functionName = "PulsarFunction-test";
            String subscriptionName = "test-sub";
            this.admin.namespaces().createNamespace("external-repl-prop/io");
            HashSet clusters = Sets.newHashSet((Iterable)Lists.newArrayList((Object[])new String[]{CLUSTER}));
            this.admin.namespaces().setNamespaceReplicationClusters("external-repl-prop/io", (Set)clusters);
            Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic("persistent://external-repl-prop/io/my-topic1").create();
            Consumer consumer = this.pulsarClient.newConsumer(Schema.STRING).topic(new String[]{"persistent://external-repl-prop/io/output"}).subscriptionName("sub").subscribe();
            FunctionConfig functionConfig = PulsarFunctionLocalRunTest.createFunctionConfig("external-repl-prop", "io", "PulsarFunction-test", "persistent://external-repl-prop/io/my-topic1", "persistent://external-repl-prop/io/output", "test-sub");
            functionConfig.setProcessingGuarantees(FunctionConfig.ProcessingGuarantees.ATLEAST_ONCE);
            functionConfig.setJar(jarFilePathUrl);
            LocalRunner localRunner = LocalRunner.builder().functionConfig(functionConfig).clientAuthPlugin(AuthenticationTls.class.getName()).clientAuthParams(String.format("tlsCertFile:%s,tlsKeyFile:%s", "./src/test/resources/authentication/tls/client-cert.pem", "./src/test/resources/authentication/tls/client-key.pem")).useTls(true).tlsTrustCertFilePath("./src/test/resources/authentication/tls/cacert.pem").tlsAllowInsecureConnection(true).tlsHostNameVerificationEnabled(false).brokerServiceUrl("pulsar://127.0.0.1:" + this.config.getBrokerServicePortTls().get()).build();
            localRunner.start(false);
            MockedPulsarServiceBaseTest.retryStrategically(test -> {
                try {
                    TopicStats stats = this.admin.topics().getStats("persistent://external-repl-prop/io/my-topic1");
                    return stats.subscriptions.get("test-sub") != null && !((SubscriptionStats)stats.subscriptions.get((Object)"test-sub")).consumers.isEmpty();
                }
                catch (PulsarAdminException e) {
                    return false;
                }
            }, 5, 150L);
            TopicStats stats = this.admin.topics().getStats("persistent://external-repl-prop/io/my-topic1");
            Assert.assertTrue((stats.subscriptions.get("test-sub") != null && !((SubscriptionStats)stats.subscriptions.get((Object)"test-sub")).consumers.isEmpty() ? 1 : 0) != 0);
            int totalMsgs = 5;
            for (i = 0; i < totalMsgs; ++i) {
                String data = "my-message-" + i;
                producer.newMessage().property("key", "value").value((Object)data).send();
            }
            MockedPulsarServiceBaseTest.retryStrategically(test -> {
                try {
                    SubscriptionStats subStats = (SubscriptionStats)this.admin.topics().getStats((String)"persistent://external-repl-prop/io/my-topic1").subscriptions.get("test-sub");
                    return subStats.unackedMessages == 0L;
                }
                catch (PulsarAdminException e) {
                    return false;
                }
            }, 5, 150L);
            for (i = 0; i < totalMsgs; ++i) {
                Message msg = consumer.receive(5, TimeUnit.SECONDS);
                String receivedPropertyValue = msg.getProperty("key");
                Assert.assertEquals((String)"value", (String)receivedPropertyValue);
                Assert.assertEquals((String)((String)msg.getValue()), (String)("my-message-" + i + "!"));
            }
            Assert.assertNotEquals((Object)((SubscriptionStats)this.admin.topics().getStats((String)"persistent://external-repl-prop/io/my-topic1").subscriptions.values().iterator().next()).unackedMessages, (Object)totalMsgs);
            localRunner.stop();
            MockedPulsarServiceBaseTest.retryStrategically(test -> {
                try {
                    TopicStats topicStats = this.admin.topics().getStats("persistent://external-repl-prop/io/my-topic1");
                    return topicStats.subscriptions.get("test-sub") != null && ((SubscriptionStats)topicStats.subscriptions.get((Object)"test-sub")).consumers.isEmpty();
                }
                catch (PulsarAdminException e) {
                    return false;
                }
            }, 20, 150L);
            TopicStats topicStats = this.admin.topics().getStats("persistent://external-repl-prop/io/my-topic1");
            Assert.assertTrue((topicStats.subscriptions.get("test-sub") != null && ((SubscriptionStats)topicStats.subscriptions.get((Object)"test-sub")).consumers.isEmpty() ? 1 : 0) != 0);
            MockedPulsarServiceBaseTest.retryStrategically(test -> {
                try {
                    return this.admin.topics().getStats((String)"persistent://external-repl-prop/io/output").publishers.size() == 0;
                }
                catch (PulsarAdminException e) {
                    return e.getStatusCode() == 404;
                }
            }, 10, 150L);
            try {
                Assert.assertEquals((int)this.admin.topics().getStats((String)"persistent://external-repl-prop/io/output").publishers.size(), (int)0);
            }
            catch (PulsarAdminException e) {
                if (e.getStatusCode() == 404) break block4;
                Assert.fail();
            }
        }
    }

    @Test(timeOut=20000L)
    public void testE2EPulsarFunctionLocalRun() throws Exception {
        this.testE2EPulsarFunctionLocalRun(null);
    }

    @Test(timeOut=20000L)
    public void testE2EPulsarFunctionLocalRunWithJar() throws Exception {
        String jarFilePathUrl = "file:" + this.getClass().getClassLoader().getResource("pulsar-functions-api-examples.jar").getFile();
        this.testE2EPulsarFunctionLocalRun(jarFilePathUrl);
    }

    @Test(timeOut=40000L)
    public void testE2EPulsarFunctionLocalRunURL() throws Exception {
        String jarFilePathUrl = String.format("http://127.0.0.1:%d/pulsar-functions-api-examples.jar", fileServerPort);
        this.testE2EPulsarFunctionLocalRun(jarFilePathUrl);
    }

    private void testPulsarSourceLocalRun(String jarFilePathUrl) throws Exception {
        block3: {
            String namespacePortion = "io";
            String replNamespace = "external-repl-prop/io";
            String sinkTopic = "persistent://external-repl-prop/io/output";
            String sourceName = "PulsarSource-test";
            this.admin.namespaces().createNamespace("external-repl-prop/io");
            HashSet clusters = Sets.newHashSet((Iterable)Lists.newArrayList((Object[])new String[]{CLUSTER}));
            this.admin.namespaces().setNamespaceReplicationClusters("external-repl-prop/io", (Set)clusters);
            SourceConfig sourceConfig = PulsarFunctionLocalRunTest.createSourceConfig("external-repl-prop", "io", "PulsarSource-test", "persistent://external-repl-prop/io/output");
            if (jarFilePathUrl == null || !jarFilePathUrl.endsWith(".nar")) {
                sourceConfig.setClassName(DataGeneratorSource.class.getName());
            }
            sourceConfig.setArchive(jarFilePathUrl);
            LocalRunner localRunner = LocalRunner.builder().sourceConfig(sourceConfig).clientAuthPlugin(AuthenticationTls.class.getName()).clientAuthParams(String.format("tlsCertFile:%s,tlsKeyFile:%s", "./src/test/resources/authentication/tls/client-cert.pem", "./src/test/resources/authentication/tls/client-key.pem")).useTls(true).tlsTrustCertFilePath("./src/test/resources/authentication/tls/cacert.pem").tlsAllowInsecureConnection(true).tlsHostNameVerificationEnabled(false).brokerServiceUrl("pulsar://127.0.0.1:" + this.config.getBrokerServicePortTls().get()).build();
            localRunner.start(false);
            MockedPulsarServiceBaseTest.retryStrategically(test -> {
                try {
                    return this.admin.topics().getStats((String)"persistent://external-repl-prop/io/output").publishers.size() == 1;
                }
                catch (PulsarAdminException e) {
                    return false;
                }
            }, 10, 150L);
            MockedPulsarServiceBaseTest.retryStrategically(test -> {
                try {
                    TopicStats sourceStats = this.admin.topics().getStats("persistent://external-repl-prop/io/output");
                    return sourceStats.publishers.size() == 1 && ((PublisherStats)sourceStats.publishers.get((int)0)).metadata != null && ((PublisherStats)sourceStats.publishers.get((int)0)).metadata.containsKey("id") && ((String)((PublisherStats)sourceStats.publishers.get((int)0)).metadata.get("id")).equals(String.format("%s/%s/%s", "external-repl-prop", "io", "PulsarSource-test"));
                }
                catch (PulsarAdminException e) {
                    return false;
                }
            }, 50, 150L);
            TopicStats sourceStats = this.admin.topics().getStats("persistent://external-repl-prop/io/output");
            Assert.assertEquals((int)sourceStats.publishers.size(), (int)1);
            Assert.assertNotNull((Object)((PublisherStats)sourceStats.publishers.get((int)0)).metadata);
            Assert.assertTrue((boolean)((PublisherStats)sourceStats.publishers.get((int)0)).metadata.containsKey("id"));
            Assert.assertEquals((String)((String)((PublisherStats)sourceStats.publishers.get((int)0)).metadata.get("id")), (String)String.format("%s/%s/%s", "external-repl-prop", "io", "PulsarSource-test"));
            MockedPulsarServiceBaseTest.retryStrategically(test -> {
                try {
                    return this.admin.topics().getStats((String)"persistent://external-repl-prop/io/output").publishers.size() == 1 && this.admin.topics().getInternalStats((String)"persistent://external-repl-prop/io/output").numberOfEntries > 4L;
                }
                catch (PulsarAdminException e) {
                    return false;
                }
            }, 50, 150L);
            Assert.assertEquals((int)this.admin.topics().getStats((String)"persistent://external-repl-prop/io/output").publishers.size(), (int)1);
            localRunner.stop();
            MockedPulsarServiceBaseTest.retryStrategically(test -> {
                try {
                    return this.admin.topics().getStats((String)"persistent://external-repl-prop/io/output").publishers.size() == 0;
                }
                catch (PulsarAdminException e) {
                    return e.getStatusCode() == 404;
                }
            }, 10, 150L);
            try {
                Assert.assertEquals((int)this.admin.topics().getStats((String)"persistent://external-repl-prop/io/output").publishers.size(), (int)0);
            }
            catch (PulsarAdminException e) {
                if (e.getStatusCode() == 404) break block3;
                Assert.fail();
            }
        }
    }

    @Test(timeOut=20000L)
    public void testPulsarSourceLocalRunNoArchive() throws Exception {
        this.testPulsarSourceLocalRun(null);
    }

    @Test(timeOut=20000L)
    public void testPulsarSourceLocalRunWithFile() throws Exception {
        String jarFilePathUrl = "file:" + this.getClass().getClassLoader().getResource("pulsar-io-data-generator.nar").getFile();
        this.testPulsarSourceLocalRun(jarFilePathUrl);
    }

    @Test(timeOut=40000L)
    public void testPulsarSourceLocalRunWithUrl() throws Exception {
        String jarFilePathUrl = String.format("http://127.0.0.1:%d/pulsar-io-data-generator.nar", fileServerPort);
        this.testPulsarSourceLocalRun(jarFilePathUrl);
    }

    private void testPulsarSinkStats(String jarFilePathUrl) throws Exception {
        String namespacePortion = "io";
        String replNamespace = "external-repl-prop/io";
        String sourceTopic = "persistent://external-repl-prop/io/input";
        String sinkName = "PulsarSink-test";
        String propertyKey = "key";
        String propertyValue = "value";
        String subscriptionName = "test-sub";
        this.admin.namespaces().createNamespace("external-repl-prop/io");
        HashSet clusters = Sets.newHashSet((Iterable)Lists.newArrayList((Object[])new String[]{CLUSTER}));
        this.admin.namespaces().setNamespaceReplicationClusters("external-repl-prop/io", (Set)clusters);
        Producer producer = this.pulsarClient.newProducer(Schema.STRING).topic("persistent://external-repl-prop/io/input").create();
        SinkConfig sinkConfig = PulsarFunctionLocalRunTest.createSinkConfig("external-repl-prop", "io", "PulsarSink-test", "persistent://external-repl-prop/io/input", "test-sub");
        sinkConfig.setInputSpecs(Collections.singletonMap("persistent://external-repl-prop/io/input", ConsumerConfig.builder().receiverQueueSize(Integer.valueOf(1000)).build()));
        if (jarFilePathUrl == null || !jarFilePathUrl.endsWith(".nar")) {
            sinkConfig.setClassName(DataGeneratorPrintSink.class.getName());
        }
        sinkConfig.setArchive(jarFilePathUrl);
        LocalRunner localRunner = LocalRunner.builder().sinkConfig(sinkConfig).clientAuthPlugin(AuthenticationTls.class.getName()).clientAuthParams(String.format("tlsCertFile:%s,tlsKeyFile:%s", "./src/test/resources/authentication/tls/client-cert.pem", "./src/test/resources/authentication/tls/client-key.pem")).useTls(true).tlsTrustCertFilePath("./src/test/resources/authentication/tls/cacert.pem").tlsAllowInsecureConnection(true).tlsHostNameVerificationEnabled(false).brokerServiceUrl("pulsar://127.0.0.1:" + this.config.getBrokerServicePortTls().get()).build();
        localRunner.start(false);
        MockedPulsarServiceBaseTest.retryStrategically(test -> {
            try {
                TopicStats topicStats = this.admin.topics().getStats("persistent://external-repl-prop/io/input");
                return topicStats.subscriptions.containsKey("test-sub") && ((SubscriptionStats)topicStats.subscriptions.get((Object)"test-sub")).consumers.size() == 1 && ((ConsumerStats)((SubscriptionStats)topicStats.subscriptions.get((Object)"test-sub")).consumers.get((int)0)).availablePermits == 1000;
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 20, 150L);
        TopicStats topicStats = this.admin.topics().getStats("persistent://external-repl-prop/io/input");
        Assert.assertEquals((int)topicStats.subscriptions.size(), (int)1);
        Assert.assertTrue((boolean)topicStats.subscriptions.containsKey("test-sub"));
        Assert.assertEquals((int)((SubscriptionStats)topicStats.subscriptions.get((Object)"test-sub")).consumers.size(), (int)1);
        Assert.assertEquals((int)((ConsumerStats)((SubscriptionStats)topicStats.subscriptions.get((Object)"test-sub")).consumers.get((int)0)).availablePermits, (int)1000);
        int totalMsgs = 10;
        for (int i = 0; i < totalMsgs; ++i) {
            String data = "my-message-" + i;
            producer.newMessage().property("key", "value").value((Object)data).send();
        }
        MockedPulsarServiceBaseTest.retryStrategically(test -> {
            try {
                SubscriptionStats subStats = (SubscriptionStats)this.admin.topics().getStats((String)"persistent://external-repl-prop/io/input").subscriptions.get("test-sub");
                return subStats.unackedMessages == 0L && subStats.msgThroughputOut == (double)totalMsgs;
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 5, 200L);
        localRunner.stop();
        MockedPulsarServiceBaseTest.retryStrategically(test -> {
            try {
                TopicStats stats = this.admin.topics().getStats("persistent://external-repl-prop/io/input");
                return stats.subscriptions.get("test-sub") != null && ((SubscriptionStats)stats.subscriptions.get((Object)"test-sub")).consumers.isEmpty();
            }
            catch (PulsarAdminException e) {
                return false;
            }
        }, 20, 150L);
        topicStats = this.admin.topics().getStats("persistent://external-repl-prop/io/input");
        Assert.assertTrue((topicStats.subscriptions.get("test-sub") != null && ((SubscriptionStats)topicStats.subscriptions.get((Object)"test-sub")).consumers.isEmpty() ? 1 : 0) != 0);
    }

    @Test(timeOut=20000L)
    public void testPulsarSinkStatsNoArchive() throws Exception {
        this.testPulsarSinkStats(null);
    }

    @Test(timeOut=20000L)
    public void testPulsarSinkStatsWithFile() throws Exception {
        String jarFilePathUrl = "file:" + this.getClass().getClassLoader().getResource("pulsar-io-data-generator.nar").getFile();
        this.testPulsarSinkStats(jarFilePathUrl);
    }

    @Test(timeOut=40000L)
    public void testPulsarSinkStatsWithUrl() throws Exception {
        String jarFilePathUrl = String.format("http://127.0.0.1:%d/pulsar-io-data-generator.nar", fileServerPort);
        this.testPulsarSinkStats(jarFilePathUrl);
    }
}

