/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import org.apache.pulsar.common.util.SimpleTextOutputStream;
import org.apache.pulsar.utils.StatsOutputStream;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SimpleTextOutputStreamTest {
    private ByteBuf buf;
    private SimpleTextOutputStream stream;

    @BeforeMethod
    public void reset() {
        this.buf = Unpooled.buffer((int)4096);
        this.stream = new StatsOutputStream(this.buf);
    }

    @Test
    public void testBooleanFormat() {
        this.stream.write(false);
        Assert.assertEquals((String)this.str(), (String)"false");
        this.stream.write(true);
        Assert.assertEquals((String)this.str(), (String)"true");
    }

    @Test
    public void testLongFormat() {
        this.stream.write(0L);
        Assert.assertEquals((String)this.str(), (String)"0");
        this.stream.write(-1L);
        Assert.assertEquals((String)this.str(), (String)"-1");
        this.stream.write(123456789L);
        Assert.assertEquals((String)this.str(), (String)"123456789");
        this.stream.write(-123456789L);
        Assert.assertEquals((String)this.str(), (String)"-123456789");
        long i = 0xFFFFFFFEL;
        this.stream.write(i);
        Assert.assertEquals((String)this.str(), (String)Long.toString(i));
        this.stream.write(Long.MAX_VALUE);
        Assert.assertEquals((String)this.str(), (String)Long.toString(Long.MAX_VALUE));
        this.stream.write(Long.MIN_VALUE);
        Assert.assertEquals((String)this.str(), (String)Long.toString(Long.MIN_VALUE));
        this.stream.write(100L);
        Assert.assertEquals((String)this.str(), (String)"100");
        this.stream.write(-1000L);
        Assert.assertEquals((String)this.str(), (String)"-1000");
    }

    @Test
    public void testDoubleFormat() {
        this.stream.write(0.0);
        Assert.assertEquals((String)this.str(), (String)"0.0");
        this.stream.write(1.0);
        Assert.assertEquals((String)this.str(), (String)"1.0");
        this.stream.write(1.123456789);
        Assert.assertEquals((String)this.str(), (String)"1.123");
        this.stream.write(123456.123456789);
        Assert.assertEquals((String)this.str(), (String)"123456.123");
        this.stream.write(-123456.123456789);
        Assert.assertEquals((String)this.str(), (String)"-123456.123");
        this.stream.write(-123456.003456789);
        Assert.assertEquals((String)this.str(), (String)"-123456.003");
        this.stream.write(-123456.100456789);
        Assert.assertEquals((String)this.str(), (String)"-123456.100");
    }

    @Test
    public void testString() {
        this.stream.writeEncoded("\ufffd\b`~\ufffd\u00fd\u00fd8\u00fdH\\abcd\"");
        Assert.assertEquals((String)this.str(), (String)"\\ufffd\\u0008`~\\ufffd\\u00fd\\u00fd8\\u00fdH\\\\abcd\\\"");
    }

    public String str() {
        String s = this.buf.toString(Charset.forName("utf-8"));
        this.reset();
        return s;
    }
}

