/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.proxy;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.bookkeeper.test.PortManager;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.websocket.WebSocketService;
import org.apache.pulsar.websocket.proxy.SimpleConsumerSocket;
import org.apache.pulsar.websocket.proxy.SimpleProducerSocket;
import org.apache.pulsar.websocket.service.ProxyServer;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.apache.pulsar.websocket.service.WebSocketServiceStarter;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProxyAuthenticationTest
extends ProducerConsumerBase {
    private int port;
    private ProxyServer proxyServer;
    private WebSocketService service;
    private WebSocketClient consumeClient;
    private WebSocketClient produceClient;
    private static final Logger log = LoggerFactory.getLogger(ProxyAuthenticationTest.class);

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
        this.port = PortManager.nextFreePort();
        WebSocketProxyConfiguration config = new WebSocketProxyConfiguration();
        config.setWebServicePort(Optional.of(this.port));
        config.setClusterName("test");
        config.setAuthenticationEnabled(true);
        config.setConfigurationStoreServers("dummy");
        config.setSuperUserRoles((Set)Sets.newHashSet((Object[])new String[]{"pulsar.super_user"}));
        if (this.methodName.equals("authenticatedSocketTest") || this.methodName.equals("statsTest")) {
            config.setAuthenticationProviders((Set)Sets.newHashSet((Object[])new String[]{"org.apache.pulsar.websocket.proxy.MockAuthenticationProvider"}));
        } else {
            config.setAuthenticationProviders((Set)Sets.newHashSet((Object[])new String[]{"org.apache.pulsar.websocket.proxy.MockUnauthenticationProvider"}));
        }
        if (this.methodName.equals("anonymousSocketTest")) {
            config.setAnonymousUserRole("anonymousUser");
        }
        this.service = (WebSocketService)Mockito.spy((Object)new WebSocketService(config));
        ((WebSocketService)Mockito.doReturn((Object)this.mockZooKeeperClientFactory).when((Object)this.service)).getZooKeeperClientFactory();
        this.proxyServer = new ProxyServer(config);
        WebSocketServiceStarter.start((ProxyServer)this.proxyServer, (WebSocketService)this.service);
        log.info("Proxy Server Started");
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        try {
            executor.submit(() -> {
                try {
                    this.consumeClient.stop();
                    this.produceClient.stop();
                    log.info("proxy clients are stopped successfully");
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }).get(2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            log.error("failed to close clients ", (Throwable)e);
        }
        executor.shutdownNow();
        super.internalCleanup();
        this.service.close();
        this.proxyServer.stop();
        log.info("Finished Cleaning Up Test setup");
    }

    public void socketTest() throws Exception {
        String topic = "my-property/my-ns/my-topic1";
        String consumerUri = "ws://localhost:" + this.port + "/ws/v2/consumer/persistent/" + "my-property/my-ns/my-topic1" + "/my-sub";
        String producerUri = "ws://localhost:" + this.port + "/ws/v2/producer/persistent/" + "my-property/my-ns/my-topic1";
        URI consumeUri = URI.create(consumerUri);
        URI produceUri = URI.create(producerUri);
        this.consumeClient = new WebSocketClient();
        SimpleConsumerSocket consumeSocket = new SimpleConsumerSocket();
        this.produceClient = new WebSocketClient();
        SimpleProducerSocket produceSocket = new SimpleProducerSocket();
        this.consumeClient.start();
        ClientUpgradeRequest consumeRequest = new ClientUpgradeRequest();
        Future consumerFuture = this.consumeClient.connect((Object)consumeSocket, consumeUri, consumeRequest);
        log.info("Connecting to : {}", (Object)consumeUri);
        ClientUpgradeRequest produceRequest = new ClientUpgradeRequest();
        this.produceClient.start();
        Future producerFuture = this.produceClient.connect((Object)produceSocket, produceUri, produceRequest);
        Assert.assertTrue((boolean)((Session)consumerFuture.get()).isOpen());
        Assert.assertTrue((boolean)((Session)producerFuture.get()).isOpen());
        consumeSocket.awaitClose(1, TimeUnit.SECONDS);
        produceSocket.awaitClose(1, TimeUnit.SECONDS);
        Assert.assertTrue((produceSocket.getBuffer().size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals(produceSocket.getBuffer(), consumeSocket.getBuffer());
    }

    @Test(timeOut=10000L)
    public void authenticatedSocketTest() throws Exception {
        this.socketTest();
    }

    @Test(timeOut=10000L)
    public void anonymousSocketTest() throws Exception {
        this.socketTest();
    }

    @Test(timeOut=10000L)
    public void unauthenticatedSocketTest() throws Exception {
        Exception exception = null;
        try {
            this.socketTest();
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertTrue((boolean)(exception instanceof ExecutionException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeOut=10000L)
    public void statsTest() throws Exception {
        String topic = "persistent/my-property/my-ns/my-topic2";
        String consumerUri = "ws://localhost:" + this.port + "/ws/v2/consumer/" + "persistent/my-property/my-ns/my-topic2" + "/my-sub";
        String producerUri = "ws://localhost:" + this.port + "/ws/v2/producer/" + "persistent/my-property/my-ns/my-topic2";
        URI consumeUri = URI.create(consumerUri);
        URI produceUri = URI.create(producerUri);
        WebSocketClient consumeClient = new WebSocketClient();
        SimpleConsumerSocket consumeSocket = new SimpleConsumerSocket();
        WebSocketClient produceClient = new WebSocketClient();
        SimpleProducerSocket produceSocket = new SimpleProducerSocket();
        String baseUrl = "http://localhost:" + this.port + "/admin/v2/proxy-stats/";
        Client client = ClientBuilder.newClient();
        try {
            consumeClient.start();
            ClientUpgradeRequest consumeRequest = new ClientUpgradeRequest();
            Future consumerFuture = consumeClient.connect((Object)consumeSocket, consumeUri, consumeRequest);
            Assert.assertTrue((boolean)((Session)consumerFuture.get()).isOpen());
            produceClient.start();
            ClientUpgradeRequest produceRequest = new ClientUpgradeRequest();
            Future producerFuture = produceClient.connect((Object)produceSocket, produceUri, produceRequest);
            Assert.assertTrue((boolean)((Session)producerFuture.get()).isOpen());
            int retry = 0;
            int maxRetry = 500;
            while (consumeSocket.getReceivedMessagesCount() < 3) {
                Thread.sleep(10L);
                if (retry++ <= maxRetry) continue;
            }
            this.service.getProxyStats().generate();
            this.verifyResponseStatus(client, baseUrl + "metrics");
            this.verifyResponseStatus(client, baseUrl + "stats");
            this.verifyResponseStatus(client, baseUrl + "persistent/my-property/my-ns/my-topic2" + "/stats");
        }
        finally {
            consumeClient.stop();
            produceClient.stop();
            client.close();
        }
    }

    private void verifyResponseStatus(Client client, String url) {
        WebTarget webTarget = client.target(url);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
        Response response = invocationBuilder.get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }
}

