/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.proxy;

import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.bookkeeper.test.PortManager;
import org.apache.pulsar.broker.auth.MockedPulsarServiceBaseTest;
import org.apache.pulsar.broker.authorization.AuthorizationService;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.ClusterData;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.websocket.WebSocketService;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ProxyAuthorizationTest
extends MockedPulsarServiceBaseTest {
    private WebSocketService service;
    private static final int TEST_PORT = PortManager.nextFreePort();
    private final String configClusterName = "c1";

    @Override
    @BeforeClass
    protected void setup() throws Exception {
        this.conf.setClusterName("c1");
        this.internalSetup();
        WebSocketProxyConfiguration config = new WebSocketProxyConfiguration();
        HashSet superUser = Sets.newHashSet((Object[])new String[]{""});
        config.setAuthorizationEnabled(true);
        config.setConfigurationStoreServers("dummy-zk-servers");
        config.setSuperUserRoles((Set)superUser);
        config.setClusterName("c1");
        config.setWebServicePort(Optional.of(TEST_PORT));
        this.service = (WebSocketService)Mockito.spy((Object)new WebSocketService(config));
        ((WebSocketService)Mockito.doReturn((Object)this.mockZooKeeperClientFactory).when((Object)this.service)).getZooKeeperClientFactory();
        this.service.start();
    }

    @Override
    @AfterClass
    protected void cleanup() throws Exception {
        this.internalCleanup();
        this.service.close();
    }

    @Test
    public void test() throws Exception {
        AuthorizationService auth = this.service.getAuthorizationService();
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null));
        this.admin.clusters().createCluster("c1", new ClusterData());
        this.admin.tenants().createTenant("p1", new TenantInfo((Set)Sets.newHashSet((Object[])new String[]{"role1"}), (Set)Sets.newHashSet((Object[])new String[]{"c1"})));
        ProxyAuthorizationTest.waitForChange();
        this.admin.namespaces().createNamespace("p1/c1/ns1");
        ProxyAuthorizationTest.waitForChange();
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null));
        this.admin.namespaces().grantPermissionOnNamespace("p1/c1/ns1", "my-role", EnumSet.of(AuthAction.produce));
        ProxyAuthorizationTest.waitForChange();
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null));
        Assert.assertTrue((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null));
        this.admin.topics().grantPermission("persistent://p1/c1/ns1/ds2", "other-role", EnumSet.of(AuthAction.consume));
        ProxyAuthorizationTest.waitForChange();
        Assert.assertTrue((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "other-role", null));
        Assert.assertTrue((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null));
        Assert.assertFalse((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "other-role", null));
        Assert.assertTrue((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "other-role", null, null));
        Assert.assertFalse((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds2"), "no-access-role", null, null));
        Assert.assertFalse((boolean)auth.canLookup(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "no-access-role", null));
        this.admin.namespaces().grantPermissionOnNamespace("p1/c1/ns1", "my-role", EnumSet.allOf(AuthAction.class));
        ProxyAuthorizationTest.waitForChange();
        Assert.assertTrue((boolean)auth.canProduce(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null));
        Assert.assertTrue((boolean)auth.canConsume(TopicName.get((String)"persistent://p1/c1/ns1/ds1"), "my-role", null, null));
        this.admin.namespaces().deleteNamespace("p1/c1/ns1");
        this.admin.tenants().deleteTenant("p1");
        this.admin.clusters().deleteCluster("c1");
    }

    private static void waitForChange() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

