/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.proxy;

import java.util.Optional;
import org.apache.bookkeeper.test.PortManager;
import org.apache.pulsar.client.api.ProducerConsumerBase;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.websocket.WebSocketService;
import org.apache.pulsar.websocket.service.WebSocketProxyConfiguration;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ProxyConfigurationTest
extends ProducerConsumerBase {
    private WebSocketProxyConfiguration config;

    @Override
    @BeforeMethod
    public void setup() throws Exception {
        super.internalSetup();
        super.producerBaseSetup();
        this.config = new WebSocketProxyConfiguration();
        this.config.setWebServicePort(Optional.of(PortManager.nextFreePort()));
        this.config.setClusterName("test");
        this.config.setConfigurationStoreServers("dummy-zk-servers");
    }

    @Override
    @AfterMethod
    protected void cleanup() throws Exception {
        super.internalCleanup();
    }

    @DataProvider(name="setProxyConfig")
    public Object[][] setProxyConfig() {
        return new Object[][]{{2, 1}, {4, 2}};
    }

    @Test(dataProvider="setProxyConfig", timeOut=10000L)
    public void configTest(int numIoThreads, int connectionsPerBroker) throws Exception {
        this.config.setWebSocketNumIoThreads(numIoThreads);
        this.config.setWebSocketConnectionsPerBroker(connectionsPerBroker);
        WebSocketService service = (WebSocketService)Mockito.spy((Object)new WebSocketService(this.config));
        ((WebSocketService)Mockito.doReturn((Object)this.mockZooKeeperClientFactory).when((Object)service)).getZooKeeperClientFactory();
        service.start();
        PulsarClientImpl client = (PulsarClientImpl)service.getPulsarClient();
        Assert.assertEquals((int)client.getConfiguration().getNumIoThreads(), (int)numIoThreads);
        Assert.assertEquals((int)client.getConfiguration().getConnectionsPerBroker(), (int)connectionsPerBroker);
        service.close();
    }
}

