/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.influxdb.v1;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.common.IOConfigUtils;
import org.apache.pulsar.io.core.SinkContext;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class InfluxDBSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", help="The url of the InfluxDB instance to connect to")
    private String influxdbUrl;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="The username used to authenticate to InfluxDB")
    private String username;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="The password used to authenticate to InfluxDB")
    private String password;
    @FieldDoc(required=true, defaultValue="", help="The InfluxDB database to write to")
    private String database;
    @FieldDoc(required=false, defaultValue="ONE", help="The consistency level for writing data to InfluxDB. Possible values [ALL, ANY, ONE, QUORUM]")
    private String consistencyLevel = "ONE";
    @FieldDoc(required=false, defaultValue="NONE", help="The log level for InfluxDB request and response. Possible values [NONE, BASIC, HEADERS, FULL]")
    private String logLevel = "NONE";
    @FieldDoc(required=false, defaultValue="autogen", help="The retention policy for the InfluxDB database")
    private String retentionPolicy = "autogen";
    @FieldDoc(required=false, defaultValue="false", help="Flag to determine if gzip should be enabled")
    private boolean gzipEnable = false;
    @FieldDoc(required=false, defaultValue="1000", help="The InfluxDB operation time in milliseconds")
    private long batchTimeMs = 1000L;
    @FieldDoc(required=false, defaultValue="200", help="The batch size of write to InfluxDB database")
    private int batchSize = 200;

    public static InfluxDBSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (InfluxDBSinkConfig)mapper.readValue(new File(yamlFile), InfluxDBSinkConfig.class);
    }

    public static InfluxDBSinkConfig load(Map<String, Object> map, SinkContext sinkContext) throws IOException {
        return (InfluxDBSinkConfig)IOConfigUtils.loadWithSecrets(map, InfluxDBSinkConfig.class, (SinkContext)sinkContext);
    }

    public void validate() {
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0, (Object)"batchSize must be a positive integer.");
        Preconditions.checkArgument((this.batchTimeMs > 0L ? 1 : 0) != 0, (Object)"batchTimeMs must be a positive long.");
    }

    public String getInfluxdbUrl() {
        return this.influxdbUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public String getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public boolean isGzipEnable() {
        return this.gzipEnable;
    }

    public long getBatchTimeMs() {
        return this.batchTimeMs;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public InfluxDBSinkConfig setInfluxdbUrl(String influxdbUrl) {
        this.influxdbUrl = influxdbUrl;
        return this;
    }

    public InfluxDBSinkConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public InfluxDBSinkConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public InfluxDBSinkConfig setDatabase(String database) {
        this.database = database;
        return this;
    }

    public InfluxDBSinkConfig setConsistencyLevel(String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    public InfluxDBSinkConfig setLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public InfluxDBSinkConfig setRetentionPolicy(String retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
        return this;
    }

    public InfluxDBSinkConfig setGzipEnable(boolean gzipEnable) {
        this.gzipEnable = gzipEnable;
        return this;
    }

    public InfluxDBSinkConfig setBatchTimeMs(long batchTimeMs) {
        this.batchTimeMs = batchTimeMs;
        return this;
    }

    public InfluxDBSinkConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfluxDBSinkConfig)) {
            return false;
        }
        InfluxDBSinkConfig other = (InfluxDBSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGzipEnable() != other.isGzipEnable()) {
            return false;
        }
        if (this.getBatchTimeMs() != other.getBatchTimeMs()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        String this$influxdbUrl = this.getInfluxdbUrl();
        String other$influxdbUrl = other.getInfluxdbUrl();
        if (this$influxdbUrl == null ? other$influxdbUrl != null : !this$influxdbUrl.equals(other$influxdbUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$consistencyLevel = this.getConsistencyLevel();
        String other$consistencyLevel = other.getConsistencyLevel();
        if (this$consistencyLevel == null ? other$consistencyLevel != null : !this$consistencyLevel.equals(other$consistencyLevel)) {
            return false;
        }
        String this$logLevel = this.getLogLevel();
        String other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        String this$retentionPolicy = this.getRetentionPolicy();
        String other$retentionPolicy = other.getRetentionPolicy();
        return !(this$retentionPolicy == null ? other$retentionPolicy != null : !this$retentionPolicy.equals(other$retentionPolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InfluxDBSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGzipEnable() ? 79 : 97);
        long $batchTimeMs = this.getBatchTimeMs();
        result = result * 59 + (int)($batchTimeMs >>> 32 ^ $batchTimeMs);
        result = result * 59 + this.getBatchSize();
        String $influxdbUrl = this.getInfluxdbUrl();
        result = result * 59 + ($influxdbUrl == null ? 43 : $influxdbUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $consistencyLevel = this.getConsistencyLevel();
        result = result * 59 + ($consistencyLevel == null ? 43 : $consistencyLevel.hashCode());
        String $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        String $retentionPolicy = this.getRetentionPolicy();
        result = result * 59 + ($retentionPolicy == null ? 43 : $retentionPolicy.hashCode());
        return result;
    }

    public String toString() {
        return "InfluxDBSinkConfig(influxdbUrl=" + this.getInfluxdbUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ", consistencyLevel=" + this.getConsistencyLevel() + ", logLevel=" + this.getLogLevel() + ", retentionPolicy=" + this.getRetentionPolicy() + ", gzipEnable=" + this.isGzipEnable() + ", batchTimeMs=" + this.getBatchTimeMs() + ", batchSize=" + this.getBatchSize() + ")";
    }
}

