/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SslContext;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyConnection;
import org.apache.pulsar.proxy.server.ProxyService;

public class ServiceChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    private final ProxyService proxyService;
    private final SslContext serverSslCtx;
    private final SslContext clientSslCtx;

    public ServiceChannelInitializer(ProxyService proxyService, ProxyConfiguration serviceConfig, boolean enableTLS) throws Exception {
        this.proxyService = proxyService;
        this.serverSslCtx = enableTLS ? SecurityUtility.createNettySslContextForServer((boolean)true, (String)serviceConfig.getTlsTrustCertsFilePath(), (String)serviceConfig.getTlsCertificateFilePath(), (String)serviceConfig.getTlsKeyFilePath(), serviceConfig.getTlsCiphers(), serviceConfig.getTlsProtocols(), (boolean)serviceConfig.isTlsRequireTrustedClientCertOnConnect()) : null;
        if (serviceConfig.isTlsEnabledWithBroker()) {
            AuthenticationDataProvider authData = null;
            if (!StringUtils.isEmpty((CharSequence)serviceConfig.getBrokerClientAuthenticationPlugin())) {
                authData = AuthenticationFactory.create((String)serviceConfig.getBrokerClientAuthenticationPlugin(), (String)serviceConfig.getBrokerClientAuthenticationParameters()).getAuthData();
            }
            this.clientSslCtx = authData != null && authData.hasDataForTls() ? SecurityUtility.createNettySslContextForClient((boolean)serviceConfig.isTlsAllowInsecureConnection(), (String)serviceConfig.getBrokerClientTrustCertsFilePath(), (Certificate[])((X509Certificate[])authData.getTlsCertificates()), (PrivateKey)authData.getTlsPrivateKey()) : SecurityUtility.createNettySslContextForClient((boolean)serviceConfig.isTlsAllowInsecureConnection(), (String)serviceConfig.getBrokerClientTrustCertsFilePath());
        } else {
            this.clientSslCtx = null;
        }
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.serverSslCtx != null) {
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)this.serverSslCtx.newHandler(ch.alloc()));
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x500000, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)new ProxyConnection(this.proxyService, this.clientSslCtx));
    }
}

