/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server.util;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.util.SafeRunnable;
import org.apache.bookkeeper.zookeeper.BkZooKeeperClient;
import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.apache.bookkeeper.zookeeper.RetryPolicy;
import org.apache.pulsar.zookeeper.ZooKeeperClientFactory;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BkReadOnlyZookeeperClientFactoryImpl
implements ZooKeeperClientFactory {
    private static final Logger log = LoggerFactory.getLogger(BkReadOnlyZookeeperClientFactoryImpl.class);
    private final OrderedExecutor executor;

    public BkReadOnlyZookeeperClientFactoryImpl(OrderedExecutor executor) {
        this.executor = executor;
    }

    public CompletableFuture<ZooKeeper> create(String serverList, ZooKeeperClientFactory.SessionType sessionType, int zkSessionTimeoutMillis) {
        CompletableFuture<ZooKeeper> future = new CompletableFuture<ZooKeeper>();
        this.executor.execute((Runnable)SafeRunnable.safeRun(() -> {
            try {
                BkZooKeeperClient zk = BkZooKeeperClient.newBuilder().connectString(serverList).sessionTimeoutMs(zkSessionTimeoutMillis).connectRetryPolicy((RetryPolicy)new BoundExponentialBackoffRetryPolicy((long)zkSessionTimeoutMillis, (long)zkSessionTimeoutMillis, 0)).allowReadOnlyMode(sessionType == ZooKeeperClientFactory.SessionType.AllowReadOnly).build();
                if (zk.getState() == ZooKeeper.States.CONNECTEDREADONLY && sessionType != ZooKeeperClientFactory.SessionType.AllowReadOnly) {
                    future.completeExceptionally(new IllegalStateException("Cannot use a read-only session"));
                }
                log.info("ZooKeeper session established: {}", (Object)zk);
                future.complete(zk);
            }
            catch (IOException | InterruptedException | KeeperException exception) {
                log.error("Failed to establish ZooKeeper session: {}", (Object)exception.getMessage());
                future.completeExceptionally(exception);
            }
        }, throwable -> future.completeExceptionally((Throwable)throwable)));
        return future;
    }
}

