/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.proxy.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.common.protocol.Commands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyClientCnx
extends ClientCnx {
    String clientAuthRole;
    AuthData clientAuthData;
    String clientAuthMethod;
    int protocolVersion;
    private static final Logger log = LoggerFactory.getLogger(ProxyClientCnx.class);

    public ProxyClientCnx(ClientConfigurationData conf, EventLoopGroup eventLoopGroup, String clientAuthRole, AuthData clientAuthData, String clientAuthMethod, int protocolVersion) {
        super(conf, eventLoopGroup);
        this.clientAuthRole = clientAuthRole;
        this.clientAuthData = clientAuthData;
        this.clientAuthMethod = clientAuthMethod;
        this.protocolVersion = protocolVersion;
    }

    protected ByteBuf newConnectCommand() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("New Connection opened via ProxyClientCnx with params clientAuthRole = {}, clientAuthData = {}, clientAuthMethod = {}", new Object[]{this.clientAuthRole, this.clientAuthData, this.clientAuthMethod});
        }
        this.authenticationDataProvider = this.authentication.getAuthData(this.remoteHostName);
        AuthData authData = this.authenticationDataProvider.authenticate(AuthData.INIT_AUTH_DATA);
        return Commands.newConnect((String)this.authentication.getAuthMethodName(), (AuthData)authData, (int)this.protocolVersion, (String)PulsarVersion.getVersion(), (String)this.proxyToTargetBrokerAddress, (String)this.clientAuthRole, (AuthData)this.clientAuthData, (String)this.clientAuthMethod);
    }
}

