/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.offload.jcloud.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class OffsetsCache
implements AutoCloseable {
    private static final int CACHE_TTL_SECONDS = Integer.getInteger("pulsar.jclouds.readhandleimpl.offsetsscache.ttl.seconds", 300);
    private static final int CACHE_MAX_SIZE = Integer.getInteger("pulsar.jclouds.readhandleimpl.offsetsscache.max.size", 1000000);
    private final ScheduledExecutorService cacheEvictionExecutor;
    private final Cache<Key, Long> entryOffsetsCache;

    public OffsetsCache() {
        if (CACHE_MAX_SIZE > 0) {
            this.entryOffsetsCache = CacheBuilder.newBuilder().expireAfterAccess((long)CACHE_TTL_SECONDS, TimeUnit.SECONDS).maximumSize((long)CACHE_MAX_SIZE).build();
            this.cacheEvictionExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("jcloud-offsets-cache-eviction").build());
            int period = Math.max(CACHE_TTL_SECONDS / 2, 1);
            this.cacheEvictionExecutor.scheduleAtFixedRate(() -> this.entryOffsetsCache.cleanUp(), period, period, TimeUnit.SECONDS);
        } else {
            this.cacheEvictionExecutor = null;
            this.entryOffsetsCache = null;
        }
    }

    public void put(long ledgerId, long entryId, long currentPosition) {
        if (this.entryOffsetsCache != null) {
            this.entryOffsetsCache.put((Object)new Key(ledgerId, entryId), (Object)currentPosition);
        }
    }

    public Long getIfPresent(long ledgerId, long entryId) {
        return this.entryOffsetsCache != null ? (Long)this.entryOffsetsCache.getIfPresent((Object)new Key(ledgerId, entryId)) : null;
    }

    public void clear() {
        if (this.entryOffsetsCache != null) {
            this.entryOffsetsCache.invalidateAll();
        }
    }

    @Override
    public void close() {
        if (this.cacheEvictionExecutor != null) {
            this.cacheEvictionExecutor.shutdownNow();
        }
    }

    record Key(long ledgerId, long entryId) {
    }
}

