/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.ProtonJEndpoint;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;

public abstract class EndpointImpl
implements ProtonJEndpoint {
    private EndpointState _localState = EndpointState.UNINITIALIZED;
    private EndpointState _remoteState = EndpointState.UNINITIALIZED;
    private ErrorCondition _localError = new ErrorCondition();
    private ErrorCondition _remoteError = new ErrorCondition();
    private boolean _modified;
    private EndpointImpl _transportNext;
    private EndpointImpl _transportPrev;
    private Object _context;

    public void open() {
        switch (this._localState) {
            case ACTIVE: 
            case CLOSED: 
            case UNINITIALIZED: {
                this._localState = EndpointState.ACTIVE;
            }
        }
    }

    public void close() {
        switch (this._localState) {
            case ACTIVE: 
            case CLOSED: 
            case UNINITIALIZED: {
                this._localState = EndpointState.CLOSED;
            }
        }
    }

    public EndpointState getLocalState() {
        return this._localState;
    }

    public EndpointState getRemoteState() {
        return this._remoteState;
    }

    public ErrorCondition getCondition() {
        return this._localError;
    }

    public void setCondition(ErrorCondition condition) {
        if (condition != null) {
            this._localError.copyFrom(condition);
        } else {
            this._localError.clear();
        }
    }

    public ErrorCondition getRemoteCondition() {
        return this._remoteError;
    }

    void setLocalState(EndpointState localState) {
        this._localState = localState;
    }

    void setRemoteState(EndpointState remoteState) {
        this._remoteState = remoteState;
    }

    void modified() {
        if (!this._modified) {
            this._modified = true;
            this.getConnectionImpl().addModified(this);
        }
    }

    protected abstract ConnectionImpl getConnectionImpl();

    void clearModified() {
        if (this._modified) {
            this._modified = false;
            this.getConnectionImpl().removeModified(this);
        }
    }

    boolean isModified() {
        return this._modified;
    }

    EndpointImpl transportNext() {
        return this._transportNext;
    }

    EndpointImpl transportPrev() {
        return this._transportPrev;
    }

    public void free() {
        if (this._transportNext != null) {
            this._transportNext.setTransportPrev(this._transportPrev);
        }
        if (this._transportPrev != null) {
            this._transportPrev.setTransportNext(this._transportNext);
        }
    }

    void setTransportNext(EndpointImpl transportNext) {
        this._transportNext = transportNext;
    }

    void setTransportPrev(EndpointImpl transportPrevious) {
        this._transportPrev = transportPrevious;
    }

    public Object getContext() {
        return this._context;
    }

    public void setContext(Object context) {
        this._context = context;
    }

    public String toString() {
        return "EndpointImpl [_localState=" + this._localState + ", _remoteState=" + this._remoteState + ", _localError=" + this._localError + ", _remoteError=" + this._remoteError + "]";
    }
}

