/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.log4j.xml.XMLWatchdog;
import org.apache.qpid.server.logging.management.LoggingManagementMBean;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class QpidLog4JConfigurator {
    public static final ReentrantLock LOCK = new ReentrantLock();
    private static Logger _logger;
    private static DOMConfigurator domConfig;

    private QpidLog4JConfigurator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configure(String filename) throws IOException, ParserConfigurationException, SAXException, IllegalLoggerLevelException {
        try {
            LOCK.lock();
            QpidLog4JConfigurator.parseXMLConfigFile(filename);
            QpidLog4JConfigurator.checkLoggerLevels(filename);
            DOMConfigurator.configure((String)filename);
            if (_logger == null) {
                _logger = Logger.getLogger(QpidLog4JConfigurator.class);
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    public static void configureAndWatch(String filename, long delay) throws IOException, ParserConfigurationException, SAXException, IllegalLoggerLevelException {
        QpidLog4JConfigurator.parseXMLConfigFile(filename);
        QpidLog4JConfigurator.checkLoggerLevels(filename);
        QpidLog4JXMLWatchdog watchdog = new QpidLog4JXMLWatchdog(filename);
        watchdog.setDelay(delay);
        watchdog.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseXMLConfigFile(String fileName) throws IOException, SAXException, ParserConfigurationException {
        try {
            LOCK.lock();
            if (fileName == null) {
                throw new IOException("Provided log4j XML configuration filename was null");
            }
            File configFile = new File(fileName);
            if (!configFile.exists()) {
                throw new IOException("The log4j XML configuration file does not exist: " + fileName);
            }
            if (!configFile.canRead()) {
                throw new IOException("The log4j XML configuration file is not readable: " + fileName);
            }
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            QpidLog4JSaxErrorHandler errHandler = new QpidLog4JSaxErrorHandler();
            docFactory.setValidating(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(errHandler);
            docBuilder.setEntityResolver((EntityResolver)new Log4jEntityResolver());
            docBuilder.parse(fileName);
        }
        finally {
            LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void checkLoggerLevels(String filename) throws IllegalLoggerLevelException, IOException {
        try {
            LOCK.lock();
            Map<String, String> loggersLevels = LoggingManagementMBean.retrieveConfigFileLoggersLevels(filename);
            String rootLoggerlevelString = LoggingManagementMBean.retrieveConfigFileRootLoggerLevel(filename);
            loggersLevels.put("Root", rootLoggerlevelString);
            for (Map.Entry<String, String> entry : loggersLevels.entrySet()) {
                String loggerName = entry.getKey();
                String levelString = entry.getValue();
                String log4jConfiguredString = domConfig.subst(levelString);
                if (log4jConfiguredString.equals("") && !log4jConfiguredString.equals(levelString)) {
                    if (_logger != null) {
                        _logger.warn((Object)("Unable to detect Level value from '" + levelString + "' for logger '" + loggerName + "', Log4J will default this to DEBUG"));
                        continue;
                    }
                    System.err.println("Unable to detect Level value from '" + levelString + "' for logger " + loggerName + ", Log4J will default this to DEBUG");
                    continue;
                }
                QpidLog4JConfigurator.checkLevel(loggerName, log4jConfiguredString);
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    private static void checkLevel(String loggerName, String levelString) throws IllegalLoggerLevelException {
        if ("null".equalsIgnoreCase(levelString) || "inherited".equalsIgnoreCase(levelString)) {
            return;
        }
        Level level = Level.toLevel((String)levelString);
        if (level.equals((Object)Level.DEBUG) && !levelString.equalsIgnoreCase("debug")) {
            throw new IllegalLoggerLevelException("Level '" + levelString + "' specified for Logger '" + loggerName + "' is invalid");
        }
    }

    static {
        domConfig = new DOMConfigurator();
    }

    public static class IllegalLoggerLevelException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalLoggerLevelException(String msg) {
            super(msg);
        }
    }

    private static class QpidLog4JXMLWatchdog
    extends XMLWatchdog {
        public QpidLog4JXMLWatchdog(String filename) {
            super(filename);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doOnChange() {
            try {
                LOCK.lock();
                try {
                    QpidLog4JConfigurator.parseXMLConfigFile(this.filename);
                }
                catch (Exception e) {
                    if (_logger != null) {
                        _logger.warn((Object)("Parsing the log4j XML configuration file generated errors/warnings. The new configuration was not applied. Correct the issues to prompt another update attempt: " + e.getMessage()));
                    }
                    LOCK.unlock();
                    return;
                }
                try {
                    QpidLog4JConfigurator.checkLoggerLevels(this.filename);
                }
                catch (Exception e) {
                    if (_logger != null) {
                        _logger.warn((Object)("Errors were found when validating the logger level values in the log4j XML configuration file. The new configuration was not applied. Correct the issues to prompt another update attempt: " + e.getMessage()));
                    }
                    LOCK.unlock();
                    return;
                }
                super.doOnChange();
                if (_logger == null) {
                    _logger = Logger.getLogger(QpidLog4JConfigurator.class);
                }
                _logger.info((Object)("Applied log4j configuration from: " + this.filename));
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    public static class QpidLog4JSaxErrorHandler
    implements ErrorHandler {
        public void error(SAXParseException e) throws SAXException {
            if (_logger != null) {
                _logger.warn((Object)QpidLog4JSaxErrorHandler.constructMessage("Error parsing XML file", e));
            } else {
                System.err.println(QpidLog4JSaxErrorHandler.constructMessage("Error parsing XML file", e));
            }
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException(QpidLog4JSaxErrorHandler.constructMessage("Fatal error parsing XML file", e));
        }

        public void warning(SAXParseException e) throws SAXException {
            if (_logger != null) {
                _logger.warn((Object)QpidLog4JSaxErrorHandler.constructMessage("Warning parsing XML file", e));
            } else {
                System.err.println(QpidLog4JSaxErrorHandler.constructMessage("Warning parsing XML file", e));
            }
        }

        private static String constructMessage(String msg, SAXParseException ex) {
            return msg + ": Line " + ex.getLineNumber() + " column " + ex.getColumnNumber() + ": " + ex.getMessage();
        }
    }
}

