/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.AMQException;
import org.apache.qpid.qmf.QMFClass;
import org.apache.qpid.qmf.QMFCommand;
import org.apache.qpid.qmf.QMFCommandCompletionCommand;
import org.apache.qpid.qmf.QMFCommandHeader;
import org.apache.qpid.qmf.QMFMessage;
import org.apache.qpid.qmf.QMFObject;
import org.apache.qpid.qmf.QMFPackage;
import org.apache.qpid.qmf.QMFService;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.codec.BBDecoder;

public class QMFGetQueryCommand
extends QMFCommand {
    private Map<String, Object> _map;

    public QMFGetQueryCommand(QMFCommandHeader header, BBDecoder decoder) {
        super(header);
        this._map = decoder.readMap();
    }

    public void process(VirtualHost virtualHost, ServerMessage message) {
        QMFPackage qmfPackage;
        UUID objectId;
        String exchangeName = message.getMessageHeader().getReplyToExchange();
        String routingKey = message.getMessageHeader().getReplyToRoutingKey();
        IApplicationRegistry appRegistry = virtualHost.getApplicationRegistry();
        QMFService service = appRegistry.getQMFService();
        String className = (String)this._map.get("_class");
        String packageName = (String)this._map.get("_package");
        byte[] objectIdBytes = (byte[])this._map.get("_objectId");
        if (objectIdBytes != null) {
            int i;
            long msb = 0L;
            long lsb = 0L;
            for (i = 0; i != 8; ++i) {
                msb = msb << 8 | (long)(objectIdBytes[i] & 0xFF);
            }
            for (i = 8; i != 16; ++i) {
                lsb = lsb << 8 | (long)(objectIdBytes[i] & 0xFF);
            }
            objectId = new UUID(msb, lsb);
        } else {
            objectId = null;
        }
        ArrayList<QMFCommand> commands = new ArrayList<QMFCommand>();
        long sampleTime = System.currentTimeMillis() * 1000000L;
        Collection<Object> packages = packageName != null && packageName.length() != 0 ? ((qmfPackage = service.getPackage(packageName)) == null ? Collections.EMPTY_LIST : Collections.singleton(qmfPackage)) : service.getSupportedSchemas();
        for (QMFPackage qmfPackage2 : packages) {
            QMFClass qmfClass;
            Collection<Object> qmfClasses = className != null && className.length() != 0 ? ((qmfClass = qmfPackage2.getQMFClass(className)) == null ? Collections.EMPTY_LIST : Collections.singleton(qmfClass)) : qmfPackage2.getClasses();
            for (QMFClass qmfClass2 : qmfClasses) {
                QMFObject qMFObject;
                Collection<Object> objects = objectId != null ? ((qMFObject = service.getObjectById(qmfClass2, objectId)) == null ? Collections.EMPTY_LIST : Collections.singleton(qMFObject)) : service.getObjects(qmfClass2);
                for (QMFObject object : objects) {
                    commands.add(object.asGetQueryResponseCmd(this, sampleTime));
                }
            }
        }
        commands.add(new QMFCommandCompletionCommand(this));
        for (QMFCommand cmd : commands) {
            QMFMessage responseMessage = new QMFMessage(routingKey, cmd);
            Exchange exchange = virtualHost.getExchangeRegistry().getExchange(exchangeName);
            ArrayList<? extends BaseQueue> queues = exchange.route(responseMessage);
            for (BaseQueue baseQueue : queues) {
                try {
                    baseQueue.enqueue(responseMessage);
                }
                catch (AMQException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

