/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.qmf;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.qpid.AMQException;
import org.apache.qpid.qmf.QMFCommand;
import org.apache.qpid.qmf.QMFCommandCompletionCommand;
import org.apache.qpid.qmf.QMFCommandHeader;
import org.apache.qpid.qmf.QMFMessage;
import org.apache.qpid.qmf.QMFPackage;
import org.apache.qpid.qmf.QMFPackageIndicationCommand;
import org.apache.qpid.qmf.QMFService;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.codec.BBDecoder;

public class QMFPackageQueryCommand
extends QMFCommand {
    public QMFPackageQueryCommand(QMFCommandHeader header, BBDecoder decoder) {
        super(header);
    }

    public void process(VirtualHost virtualHost, ServerMessage message) {
        String exchangeName = message.getMessageHeader().getReplyToExchange();
        String routingKey = message.getMessageHeader().getReplyToRoutingKey();
        IApplicationRegistry appRegistry = virtualHost.getApplicationRegistry();
        QMFService service = appRegistry.getQMFService();
        Collection<QMFPackage> supportedSchemas = service.getSupportedSchemas();
        QMFCommand[] commands = new QMFCommand[supportedSchemas.size() + 1];
        int i = 0;
        for (QMFPackage p : supportedSchemas) {
            commands[i++] = new QMFPackageIndicationCommand(this, p.getName());
        }
        commands[commands.length - 1] = new QMFCommandCompletionCommand(this);
        for (QMFCommand cmd : commands) {
            QMFMessage responseMessage = new QMFMessage(routingKey, cmd);
            Exchange exchange = virtualHost.getExchangeRegistry().getExchange(exchangeName);
            ArrayList<? extends BaseQueue> queues = exchange.route(responseMessage);
            for (BaseQueue baseQueue : queues) {
                try {
                    baseQueue.enqueue(responseMessage);
                }
                catch (AMQException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

