/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.management.common.mbeans.ManagedBroker;
import org.apache.qpid.management.common.mbeans.ManagedQueue;
import org.apache.qpid.management.common.mbeans.annotations.MBeanConstructor;
import org.apache.qpid.management.common.mbeans.annotations.MBeanDescription;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.ManagementActor;
import org.apache.qpid.server.management.AMQManagedObject;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.queue.AMQQueueMBean;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MBeanDescription(value="This MBean exposes the broker level management features")
public class AMQBrokerManagerMBean
extends AMQManagedObject
implements ManagedBroker {
    private final QueueRegistry _queueRegistry;
    private final ExchangeRegistry _exchangeRegistry;
    private final ExchangeFactory _exchangeFactory;
    private final DurableConfigurationStore _durableConfig;
    private final VirtualHostImpl.VirtualHostMBean _virtualHostMBean;

    @MBeanConstructor(value="Creates the Broker Manager MBean")
    public AMQBrokerManagerMBean(VirtualHostImpl.VirtualHostMBean virtualHostMBean) throws JMException {
        super(ManagedBroker.class, "VirtualHostManager");
        this._virtualHostMBean = virtualHostMBean;
        VirtualHostImpl virtualHost = virtualHostMBean.getVirtualHost();
        this._queueRegistry = virtualHost.getQueueRegistry();
        this._exchangeRegistry = virtualHost.getExchangeRegistry();
        this._durableConfig = virtualHost.getDurableConfigurationStore();
        this._exchangeFactory = virtualHost.getExchangeFactory();
    }

    @Override
    public String getObjectInstanceName() {
        return this._virtualHostMBean.getVirtualHost().getName();
    }

    public String[] getExchangeTypes() throws IOException {
        ArrayList<String> exchangeTypes = new ArrayList<String>();
        for (ExchangeType<? extends Exchange> ex : this._exchangeFactory.getPublicCreatableTypes()) {
            exchangeTypes.add(ex.getName().toString());
        }
        return exchangeTypes.toArray(new String[0]);
    }

    public List<String> retrieveQueueAttributeNames() throws IOException {
        return ManagedQueue.QUEUE_ATTRIBUTES;
    }

    public List<List<Object>> retrieveQueueAttributeValues(String[] attributes) throws IOException {
        if (this._queueRegistry.getQueues().size() == 0) {
            return new ArrayList<List<Object>>();
        }
        ArrayList<List<Object>> queueAttributesList = new ArrayList<List<Object>>(this._queueRegistry.getQueues().size());
        int attributesLength = attributes.length;
        for (AMQQueue queue : this._queueRegistry.getQueues()) {
            AMQQueueMBean mbean = (AMQQueueMBean)queue.getManagedObject();
            if (mbean == null) continue;
            ArrayList<Object> attributeValues = new ArrayList<Object>(attributesLength);
            for (int i = 0; i < attributesLength; ++i) {
                try {
                    attributeValues.add(mbean.getAttribute(attributes[i]));
                    continue;
                }
                catch (Exception e) {
                    attributeValues.add("-");
                }
            }
            queueAttributesList.add(attributeValues);
        }
        return queueAttributesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewExchange(String exchangeName, String type, boolean durable) throws JMException, MBeanException {
        CurrentActor.set(new ManagementActor(this._logActor.getRootMessageLogger()));
        try {
            ExchangeRegistry exchangeRegistry = this._exchangeRegistry;
            synchronized (exchangeRegistry) {
                Exchange exchange = this._exchangeRegistry.getExchange(new AMQShortString(exchangeName));
                if (exchange == null) {
                    exchange = this._exchangeFactory.createExchange(new AMQShortString(exchangeName), new AMQShortString(type), durable, false, 0);
                    this._exchangeRegistry.registerExchange(exchange);
                    if (durable) {
                        this._durableConfig.createExchange(exchange);
                    }
                } else {
                    throw new JMException("The exchange \"" + exchangeName + "\" already exists.");
                }
            }
        }
        catch (AMQException ex) {
            JMException jme = new JMException(ex.toString());
            throw new MBeanException(jme, "Error in creating exchange " + exchangeName);
        }
        finally {
            CurrentActor.remove();
        }
    }

    public void unregisterExchange(String exchangeName) throws JMException, MBeanException {
        CurrentActor.set(new ManagementActor(this._logActor.getRootMessageLogger()));
        try {
            this._exchangeRegistry.unregisterExchange(new AMQShortString(exchangeName), false);
        }
        catch (AMQException ex) {
            JMException jme = new JMException(ex.toString());
            throw new MBeanException(jme, "Error in unregistering exchange " + exchangeName);
        }
        finally {
            CurrentActor.remove();
        }
    }

    public void createNewQueue(String queueName, String owner, boolean durable) throws JMException, MBeanException {
        AMQQueue queue = this._queueRegistry.getQueue(new AMQShortString(queueName));
        if (queue != null) {
            throw new JMException("The queue \"" + queueName + "\" already exists.");
        }
        CurrentActor.set(new ManagementActor(this._logActor.getRootMessageLogger()));
        try {
            AMQShortString ownerShortString = null;
            if (owner != null) {
                ownerShortString = new AMQShortString(owner);
            }
            if ((queue = AMQQueueFactory.createAMQQueueImpl(new AMQShortString(queueName), durable, ownerShortString, false, false, this.getVirtualHost(), null)).isDurable() && !queue.isAutoDelete()) {
                this._durableConfig.createQueue(queue);
            }
            this._queueRegistry.registerQueue(queue);
        }
        catch (AMQException ex) {
            JMException jme = new JMException(ex.toString());
            throw new MBeanException(jme, "Error in creating queue " + queueName);
        }
        finally {
            CurrentActor.remove();
        }
    }

    private VirtualHost getVirtualHost() {
        return this._virtualHostMBean.getVirtualHost();
    }

    public void deleteQueue(String queueName) throws JMException, MBeanException {
        AMQQueue queue = this._queueRegistry.getQueue(new AMQShortString(queueName));
        if (queue == null) {
            throw new JMException("The Queue " + queueName + " is not a registered queue.");
        }
        CurrentActor.set(new ManagementActor(this._logActor.getRootMessageLogger()));
        try {
            queue.delete();
            if (queue.isDurable()) {
                this._durableConfig.removeQueue(queue);
            }
        }
        catch (AMQException ex) {
            JMException jme = new JMException(ex.toString());
            throw new MBeanException(jme, "Error in deleting queue " + queueName);
        }
        finally {
            CurrentActor.remove();
        }
    }

    @Override
    public ManagedObject getParentObject() {
        return this._virtualHostMBean;
    }

    @Override
    public ObjectName getObjectName() throws MalformedObjectNameException {
        return this.getObjectNameForSingleInstanceMBean();
    }

    public void resetStatistics() throws Exception {
        this.getVirtualHost().resetStatistics();
    }

    public double getPeakMessageDeliveryRate() {
        return this.getVirtualHost().getMessageDeliveryStatistics().getPeak();
    }

    public double getPeakDataDeliveryRate() {
        return this.getVirtualHost().getDataDeliveryStatistics().getPeak();
    }

    public double getMessageDeliveryRate() {
        return this.getVirtualHost().getMessageDeliveryStatistics().getRate();
    }

    public double getDataDeliveryRate() {
        return this.getVirtualHost().getDataDeliveryStatistics().getRate();
    }

    public long getTotalMessagesDelivered() {
        return this.getVirtualHost().getMessageDeliveryStatistics().getTotal();
    }

    public long getTotalDataDelivered() {
        return this.getVirtualHost().getDataDeliveryStatistics().getTotal();
    }

    public double getPeakMessageReceiptRate() {
        return this.getVirtualHost().getMessageReceiptStatistics().getPeak();
    }

    public double getPeakDataReceiptRate() {
        return this.getVirtualHost().getDataReceiptStatistics().getPeak();
    }

    public double getMessageReceiptRate() {
        return this.getVirtualHost().getMessageReceiptStatistics().getRate();
    }

    public double getDataReceiptRate() {
        return this.getVirtualHost().getDataReceiptStatistics().getRate();
    }

    public long getTotalMessagesReceived() {
        return this.getVirtualHost().getMessageReceiptStatistics().getTotal();
    }

    public long getTotalDataReceived() {
        return this.getVirtualHost().getDataReceiptStatistics().getTotal();
    }

    public boolean isStatisticsEnabled() {
        return this.getVirtualHost().isStatisticsEnabled();
    }
}

