/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.binding;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.queue.AMQQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Binding {
    private final String _bindingKey;
    private final AMQQueue _queue;
    private final Exchange _exchange;
    private final Map<String, Object> _arguments;
    private final UUID _id;
    private final AtomicLong _matches = new AtomicLong();

    public Binding(UUID id, String bindingKey, AMQQueue queue, Exchange exchange, Map<String, Object> arguments) {
        this._id = id;
        this._bindingKey = bindingKey;
        this._queue = queue;
        this._exchange = exchange;
        this._arguments = arguments == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(arguments);
    }

    public UUID getId() {
        return this._id;
    }

    public String getBindingKey() {
        return this._bindingKey;
    }

    public AMQQueue getQueue() {
        return this._queue;
    }

    public Exchange getExchange() {
        return this._exchange;
    }

    public Map<String, Object> getArguments() {
        return this._arguments;
    }

    public void incrementMatches() {
        this._matches.incrementAndGet();
    }

    public long getMatches() {
        return this._matches.get();
    }

    boolean isDurable() {
        return this._queue.isDurable() && this._exchange.isDurable();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Binding)) {
            return false;
        }
        Binding binding = (Binding)o;
        return (this._bindingKey == null ? binding.getBindingKey() == null : this._bindingKey.equals(binding.getBindingKey())) && (this._exchange == null ? binding.getExchange() == null : this._exchange.equals(binding.getExchange())) && (this._queue == null ? binding.getQueue() == null : this._queue.equals(binding.getQueue()));
    }

    public int hashCode() {
        int result = this._bindingKey == null ? 1 : this._bindingKey.hashCode();
        result = 31 * result + (this._queue == null ? 3 : this._queue.hashCode());
        result = 31 * result + (this._exchange == null ? 5 : this._exchange.hashCode());
        return result;
    }
}

