/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.configuration.ExchangeConfiguration;
import org.apache.qpid.server.configuration.ExchangeConfigurationPlugin;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.configuration.plugins.ConfigurationPlugin;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.store.MemoryMessageStore;

public class VirtualHostConfiguration
extends ConfigurationPlugin {
    private String _name;
    private Map<String, QueueConfiguration> _queues = new HashMap<String, QueueConfiguration>();
    private Map<String, ExchangeConfiguration> _exchanges = new HashMap<String, ExchangeConfiguration>();

    public VirtualHostConfiguration(String name, Configuration config) throws ConfigurationException {
        this._name = name;
        this.setConfiguration(config);
    }

    public void setConfiguration(Configuration config) throws ConfigurationException {
        this.setConfiguration("virtualhosts.virtualhost", config);
        for (String queueName : this.getListValue("queues.queue.name")) {
            this._queues.put(queueName, new QueueConfiguration(queueName, this));
        }
        Iterator i = this.getListValue("exchanges.exchange.name").iterator();
        int count = 0;
        while (i.hasNext()) {
            CompositeConfiguration mungedConf = new CompositeConfiguration();
            mungedConf.addConfiguration(config.subset("exchanges.exchange(" + count++ + ")"));
            mungedConf.addConfiguration(this._configuration.subset("exchanges"));
            String exchName = (String)i.next();
            this._exchanges.put(exchName, new ExchangeConfiguration(exchName, (Configuration)mungedConf));
        }
    }

    public String getName() {
        return this._name;
    }

    public long getHousekeepingExpiredMessageCheckPeriod() {
        return this.getLongValue("housekeeping.expiredMessageCheckPeriod", ApplicationRegistry.getInstance().getConfiguration().getHousekeepingCheckPeriod());
    }

    public String getAuthenticationDatabase() {
        return this.getStringValue("security.authentication.name");
    }

    public List getCustomExchanges() {
        return this.getListValue("custom-exchanges.class-name");
    }

    public Configuration getStoreConfiguration() {
        return this._configuration.subset("store");
    }

    public String getMessageStoreClass() {
        return this.getStringValue("store.class", MemoryMessageStore.class.getName());
    }

    public void setMessageStoreClass(String storeClass) {
        this._configuration.setProperty("store.class", (Object)storeClass);
    }

    public List getExchanges() {
        return this.getListValue("exchanges.exchange.name");
    }

    public String[] getQueueNames() {
        return this._queues.keySet().toArray(new String[this._queues.size()]);
    }

    public ExchangeConfiguration getExchangeConfiguration(String exchangeName) {
        return this._exchanges.get(exchangeName);
    }

    public QueueConfiguration getQueueConfiguration(String queueName) {
        if (this._queues.containsKey(queueName)) {
            return this._queues.get(queueName);
        }
        try {
            return new QueueConfiguration(queueName, this);
        }
        catch (ConfigurationException e) {
            return null;
        }
    }

    public ConfigurationPlugin getQueueConfiguration(AMQQueue queue) {
        VirtualHostConfiguration hostConfig = queue.getVirtualHost().getConfiguration();
        if (Arrays.asList(hostConfig.getQueueNames()).contains(queue.getName())) {
            return null;
        }
        ArrayList<Binding> bindings = new ArrayList<Binding>(queue.getBindings());
        ArrayList<AMQShortString> exchangeClasses = new ArrayList<AMQShortString>(bindings.size());
        for (int index = 0; index < bindings.size(); ++index) {
            if (bindings.get(index).getExchange().getNameShortString().equals(ExchangeDefaults.DEFAULT_EXCHANGE_NAME)) {
                bindings.remove(index);
                continue;
            }
            exchangeClasses.add(bindings.get(index).getExchange().getType().getName());
            if (exchangeClasses.size() <= 1) continue;
            return null;
        }
        if (bindings.isEmpty()) {
            return null;
        }
        String exchangeName = bindings.get(0).getExchange().getType().getName().toString();
        String exchangeClass = "org.apache.qpid.server.configuration." + exchangeName.substring(0, 1).toUpperCase() + exchangeName.substring(1) + "Configuration";
        ExchangeConfigurationPlugin exchangeConfiguration = (ExchangeConfigurationPlugin)queue.getVirtualHost().getConfiguration().getConfiguration(exchangeClass);
        QueueConfiguration.QueueConfig queueConfig = new QueueConfiguration.QueueConfig();
        PropertiesConfiguration newQueueConfig = new PropertiesConfiguration();
        newQueueConfig.setProperty("name", (Object)queue.getName());
        try {
            CompositeConfiguration mungedConf = new CompositeConfiguration();
            mungedConf.addConfiguration((Configuration)newQueueConfig);
            mungedConf.addConfiguration(this.getConfig().subset("queues"));
            queueConfig.setConfiguration("virtualhosts.virtualhost.queues", (Configuration)mungedConf);
        }
        catch (ConfigurationException e) {
            _logger.error((Object)"QueueConfiguration requirements have changed.");
        }
        if (exchangeConfiguration != null) {
            queueConfig.addConfiguration(exchangeConfiguration.getConfiguration(queue));
        }
        if (this._queues.containsKey(queue.getName())) {
            queueConfig.addConfiguration(this._queues.get(queue.getName()));
        }
        return queueConfig;
    }

    public long getMemoryUsageMaximum() {
        return this.getLongValue("queues.maximumMemoryUsage");
    }

    public long getMemoryUsageMinimum() {
        return this.getLongValue("queues.minimumMemoryUsage");
    }

    public int getMaximumMessageAge() {
        return this.getIntValue("queues.maximumMessageAge");
    }

    public Long getMaximumQueueDepth() {
        return this.getLongValue("queues.maximumQueueDepth");
    }

    public Long getMaximumMessageSize() {
        return this.getLongValue("queues.maximumMessageSize");
    }

    public Long getMaximumMessageCount() {
        return this.getLongValue("queues.maximumMessageCount");
    }

    public Long getMinimumAlertRepeatGap() {
        return this.getLongValue("queues.minimumAlertRepeatGap");
    }

    public long getCapacity() {
        return this.getLongValue("queues.capacity");
    }

    public long getFlowResumeCapacity() {
        return this.getLongValue("queues.flowResumeCapacity", this.getCapacity());
    }

    public String[] getElementsProcessed() {
        return new String[]{"queues", "exchanges", "custom-exchanges", "store", "housekeeping"};
    }

    public void validateConfiguration() throws ConfigurationException {
    }

    public int getHouseKeepingThreadCount() {
        return this.getIntValue("housekeeping.poolSize", Runtime.getRuntime().availableProcessors());
    }

    public long getTransactionTimeoutOpenWarn() {
        return this.getLongValue("transactionTimeout.openWarn", 0L);
    }

    public long getTransactionTimeoutOpenClose() {
        return this.getLongValue("transactionTimeout.openClose", 0L);
    }

    public long getTransactionTimeoutIdleWarn() {
        return this.getLongValue("transactionTimeout.idleWarn", 0L);
    }

    public long getTransactionTimeoutIdleClose() {
        return this.getLongValue("transactionTimeout.idleClose", 0L);
    }
}

