/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.management.JMException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.AbstractExchangeMBean;
import org.apache.qpid.server.exchange.ExchangeType;
import org.apache.qpid.server.exchange.HeadersBinding;
import org.apache.qpid.server.exchange.HeadersExchangeMBean;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadersExchange
extends AbstractExchange {
    private static final Logger _logger = Logger.getLogger(HeadersExchange.class);
    private final ConcurrentHashMap<String, CopyOnWriteArraySet<Binding>> _bindingsByKey = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<HeadersBinding> _bindingHeaderMatchers = new CopyOnWriteArrayList();
    public static final ExchangeType<HeadersExchange> TYPE = new ExchangeType<HeadersExchange>(){

        @Override
        public AMQShortString getName() {
            return ExchangeDefaults.HEADERS_EXCHANGE_CLASS;
        }

        @Override
        public Class<HeadersExchange> getExchangeClass() {
            return HeadersExchange.class;
        }

        @Override
        public HeadersExchange newInstance(VirtualHost host, AMQShortString name, boolean durable, int ticket, boolean autoDelete) throws AMQException {
            HeadersExchange exch = new HeadersExchange();
            exch.initialise(host, name, durable, ticket, autoDelete);
            return exch;
        }

        @Override
        public AMQShortString getDefaultExchangeName() {
            return ExchangeDefaults.HEADERS_EXCHANGE_NAME;
        }
    };

    public HeadersExchange() {
        super(TYPE);
    }

    public ArrayList<BaseQueue> doRoute(InboundMessage payload) {
        AMQMessageHeader header = payload.getMessageHeader();
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Exchange " + this.getNameShortString() + ": routing message with headers " + header));
        }
        LinkedHashSet<AMQQueue> queues = new LinkedHashSet<AMQQueue>();
        for (HeadersBinding hb : this._bindingHeaderMatchers) {
            if (!hb.matches(header)) continue;
            Binding b = hb.getBinding();
            b.incrementMatches();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Exchange " + this.getNameShortString() + ": delivering message with headers " + header + " to " + b.getQueue().getNameShortString()));
            }
            queues.add(b.getQueue());
        }
        return new ArrayList<BaseQueue>(queues);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, FieldTable arguments, AMQQueue queue) {
        return this.isBound(routingKey, queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        String bindingKey = routingKey == null ? "" : routingKey.toString();
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(bindingKey);
        if (bindings != null) {
            for (Binding binding : bindings) {
                if (!binding.getQueue().equals(queue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isBound(AMQShortString routingKey) {
        String bindingKey = routingKey == null ? "" : routingKey.toString();
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(bindingKey);
        return bindings != null && !bindings.isEmpty();
    }

    @Override
    public boolean isBound(AMQQueue queue) {
        for (CopyOnWriteArraySet<Binding> bindings : this._bindingsByKey.values()) {
            for (Binding binding : bindings) {
                if (!binding.getQueue().equals(queue)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasBindings() {
        return !this.getBindings().isEmpty();
    }

    @Override
    protected AbstractExchangeMBean createMBean() throws JMException {
        return new HeadersExchangeMBean(this);
    }

    @Override
    public Logger getLogger() {
        return _logger;
    }

    @Override
    protected void onBind(Binding binding) {
        CopyOnWriteArraySet<Binding> newBindings;
        String bindingKey = binding.getBindingKey();
        AMQQueue queue = binding.getQueue();
        AMQShortString routingKey = AMQShortString.valueOf((Object)bindingKey);
        Map<String, Object> args = binding.getArguments();
        assert (queue != null);
        assert (routingKey != null);
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(bindingKey);
        if (bindings == null && (newBindings = this._bindingsByKey.putIfAbsent(bindingKey, bindings = new CopyOnWriteArraySet())) != null) {
            bindings = newBindings;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Exchange " + this.getNameShortString() + ": Binding " + queue.getNameShortString() + " with binding key '" + bindingKey + "' and args: " + args));
        }
        this._bindingHeaderMatchers.add(new HeadersBinding(binding));
        bindings.add(binding);
    }

    @Override
    protected void onUnbind(Binding binding) {
        assert (binding != null);
        CopyOnWriteArraySet<Binding> bindings = this._bindingsByKey.get(binding.getBindingKey());
        if (bindings != null) {
            bindings.remove(binding);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Removing Binding: " + this._bindingHeaderMatchers.remove(new HeadersBinding(binding))));
        }
    }
}

