/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange.headers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.AMQType;
import org.apache.qpid.framing.AMQTypedValue;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.exchange.headers.HeaderKey;
import org.apache.qpid.server.exchange.headers.HeaderKeyDictionary;
import org.apache.qpid.server.exchange.headers.HeaderMatcherResult;
import org.apache.qpid.server.exchange.headers.HeadersMatcherDFAState;

public class HeadersParser {
    private final HeaderKeyDictionary _dictionary = new HeaderKeyDictionary();
    private static final AMQShortString MATCHING_TYPE_KEY = new AMQShortString("x-match");
    private static final String ANY_MATCHING = "any";
    private static final AMQShortString RESERVED_KEY_PREFIX = new AMQShortString("x-");

    HeadersMatcherDFAState createStateMachine(FieldTable bindingArguments, HeaderMatcherResult result) {
        String matchingType = bindingArguments.getString(MATCHING_TYPE_KEY);
        boolean matchAny = matchingType.equalsIgnoreCase(ANY_MATCHING);
        if (matchAny) {
            return this.createStateMachineForAnyMatch(bindingArguments, result);
        }
        return this.createStateMachineForAllMatch(bindingArguments, result);
    }

    private HeadersMatcherDFAState createStateMachineForAnyMatch(FieldTable bindingArguments, HeaderMatcherResult result) {
        HeadersMatcherDFAState successState = new HeadersMatcherDFAState(Collections.EMPTY_MAP, Collections.singleton(result), this._dictionary);
        HashMap<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>> nextStateMap = new HashMap<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>>();
        HashSet<AMQShortString> seenKeys = new HashSet<AMQShortString>();
        for (Map.Entry entry : bindingArguments) {
            AMQShortString key = (AMQShortString)entry.getKey();
            AMQTypedValue value = (AMQTypedValue)entry.getValue();
            if (!seenKeys.add(key) || key.startsWith(RESERVED_KEY_PREFIX)) continue;
            AMQType type = value.getType();
            HeaderKey headerKey = this._dictionary.getOrCreate(key);
            Map<Object, HeadersMatcherDFAState> valueMap = type == AMQType.VOID || (type == AMQType.ASCII_STRING || type == AMQType.WIDE_STRING) && ((CharSequence)value.getValue()).length() == 0 ? Collections.singletonMap(null, successState) : Collections.singletonMap(value, successState);
            nextStateMap.put(headerKey, valueMap);
        }
        if (seenKeys.size() == 0) {
            return successState;
        }
        return new HeadersMatcherDFAState(nextStateMap, Collections.EMPTY_SET, this._dictionary);
    }

    private HeadersMatcherDFAState createStateMachineForAllMatch(FieldTable bindingArguments, HeaderMatcherResult result) {
        HashSet<AMQShortString> seenKeys = new HashSet<AMQShortString>();
        ArrayList<KeyValuePair> requiredTerms = new ArrayList<KeyValuePair>(bindingArguments.size());
        for (Map.Entry entry : bindingArguments) {
            AMQShortString key = (AMQShortString)entry.getKey();
            AMQTypedValue value = (AMQTypedValue)entry.getValue();
            if (!seenKeys.add(key) || key.startsWith(RESERVED_KEY_PREFIX)) continue;
            AMQType type = value.getType();
            if (type == AMQType.VOID || (type == AMQType.ASCII_STRING || type == AMQType.WIDE_STRING) && ((CharSequence)value.getValue()).length() == 0) {
                requiredTerms.add(new KeyValuePair(this._dictionary.getOrCreate(key), null));
                continue;
            }
            requiredTerms.add(new KeyValuePair(this._dictionary.getOrCreate(key), value));
        }
        HeadersMatcherDFAState successState = new HeadersMatcherDFAState(Collections.EMPTY_MAP, Collections.singleton(result), this._dictionary);
        HeadersMatcherDFAState failState = new HeadersMatcherDFAState(Collections.EMPTY_MAP, Collections.EMPTY_SET, this._dictionary);
        HashMap<Set, HeadersMatcherDFAState> notSeenTermsToStateMap = new HashMap<Set, HeadersMatcherDFAState>();
        notSeenTermsToStateMap.put(Collections.EMPTY_SET, successState);
        int numberOfTerms = requiredTerms.size();
        for (int numMissingTerms = 1; numMissingTerms <= numberOfTerms; ++numMissingTerms) {
            int[] pos = new int[numMissingTerms];
            for (int i = 0; i < numMissingTerms; ++i) {
                pos[i] = i;
            }
            int maxTermValue = numberOfTerms - (numMissingTerms - 1);
            block3: while (pos[0] < maxTermValue) {
                HashSet stateSet = new HashSet();
                for (int posIndex = 0; posIndex < pos.length; ++posIndex) {
                    stateSet.add(requiredTerms.get(pos[posIndex]));
                }
                HashMap<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>> nextStateMap = new HashMap<HeaderKey, Map<AMQTypedValue, HeadersMatcherDFAState>>();
                for (int posIndex = 0; posIndex < pos.length; ++posIndex) {
                    KeyValuePair nextTerm = (KeyValuePair)requiredTerms.get(pos[posIndex]);
                    HashSet nextStateSet = new HashSet(stateSet);
                    nextStateSet.remove(nextTerm);
                    HashMap valueToStateMap = new HashMap();
                    nextStateMap.put(nextTerm._key, valueToStateMap);
                    valueToStateMap.put(nextTerm._value, notSeenTermsToStateMap.get(nextStateSet));
                    if (nextTerm._value == null) continue;
                    valueToStateMap.put(null, failState);
                }
                HeadersMatcherDFAState newState = new HeadersMatcherDFAState(nextStateMap, Collections.EMPTY_SET, this._dictionary);
                notSeenTermsToStateMap.put(stateSet, newState);
                int i = numMissingTerms;
                while (i-- != 0) {
                    int n = i;
                    pos[n] = pos[n] + 1;
                    if (pos[n] > numberOfTerms - (numMissingTerms - i)) continue;
                    int k = pos[i];
                    for (int j = i + 1; j < numMissingTerms; ++j) {
                        pos[j] = ++k;
                    }
                    continue block3;
                }
            }
        }
        return (HeadersMatcherDFAState)notSeenTermsToStateMap.get(new HashSet(requiredTerms));
    }

    public static void main(String[] args) throws AMQFrameDecodingException {
        FieldTable bindingTable = new FieldTable();
        bindingTable.setString(new AMQShortString("x-match"), "all");
        bindingTable.setInteger("a", Integer.valueOf(1));
        bindingTable.setVoid(new AMQShortString("b"));
        bindingTable.setString("c", "");
        bindingTable.setInteger("d", Integer.valueOf(4));
        bindingTable.setInteger("e", Integer.valueOf(1));
        FieldTable bindingTable2 = new FieldTable();
        bindingTable2.setString(new AMQShortString("x-match"), "all");
        bindingTable2.setInteger("a", Integer.valueOf(1));
        bindingTable2.setVoid(new AMQShortString("b"));
        bindingTable2.setString("c", "");
        bindingTable2.setInteger("d", Integer.valueOf(4));
        bindingTable2.setInteger("e", Integer.valueOf(1));
        bindingTable2.setInteger("f", Integer.valueOf(1));
        FieldTable table = new FieldTable();
        table.setInteger("a", Integer.valueOf(1));
        table.setInteger("b", Integer.valueOf(2));
        table.setString("c", "");
        table.setInteger("d", Integer.valueOf(4));
        table.setInteger("e", Integer.valueOf(1));
        table.setInteger("f", Integer.valueOf(1));
        table.setInteger("h", Integer.valueOf(1));
        table.setInteger("i", Integer.valueOf(1));
        table.setInteger("j", Integer.valueOf(1));
        table.setInteger("k", Integer.valueOf(1));
        table.setInteger("l", Integer.valueOf(1));
        ByteBuffer buffer = ByteBuffer.allocate((int)((int)table.getEncodedSize()));
        EncodingUtils.writeFieldTableBytes((ByteBuffer)buffer, (FieldTable)table);
        buffer.flip();
        FieldTable table2 = EncodingUtils.readFieldTable((ByteBuffer)buffer);
        FieldTable bindingTable3 = new FieldTable();
        bindingTable3.setString(new AMQShortString("x-match"), ANY_MATCHING);
        bindingTable3.setInteger("a", Integer.valueOf(1));
        bindingTable3.setInteger("b", Integer.valueOf(3));
        FieldTable bindingTable4 = new FieldTable();
        bindingTable4.setString(new AMQShortString("x-match"), ANY_MATCHING);
        bindingTable4.setVoid(new AMQShortString("a"));
        FieldTable bindingTable5 = new FieldTable();
        bindingTable5.setString(new AMQShortString("x-match"), "all");
        bindingTable5.setString(new AMQShortString("h"), "hello");
        for (int i = 0; i < 100; ++i) {
            HeadersParser.printMatches(new FieldTable[]{bindingTable5}, table2);
        }
    }

    private static void printMatches(FieldTable[] bindingKeys, FieldTable routingKey) {
        HeadersMatcherDFAState sm = null;
        HashMap<HeaderMatcherResult, String> resultMap = new HashMap<HeaderMatcherResult, String>();
        HeadersParser parser = new HeadersParser();
        for (int i = 0; i < bindingKeys.length; ++i) {
            HeaderMatcherResult r = new HeaderMatcherResult();
            resultMap.put(r, bindingKeys[i].toString());
            sm = i == 0 ? parser.createStateMachine(bindingKeys[i], r) : sm.mergeStateMachines(parser.createStateMachine(bindingKeys[i], r));
        }
        Collection<HeaderMatcherResult> results = null;
        long beforeTime = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            routingKey.size();
            assert (sm != null);
            results = sm.match(routingKey);
        }
        long elapsed = System.currentTimeMillis() - beforeTime;
        System.out.println("1000000 Iterations took: " + elapsed);
        ArrayList resultStrings = new ArrayList();
        assert (results != null);
        for (HeaderMatcherResult result : results) {
            resultStrings.add(resultMap.get(result));
        }
        ArrayList<String> nonMatches = new ArrayList<String>();
        for (FieldTable key : bindingKeys) {
            nonMatches.add(key.toString());
        }
        nonMatches.removeAll(resultStrings);
        System.out.println("\"" + routingKey + "\" matched with " + resultStrings + " DID NOT MATCH with " + nonMatches);
    }

    public static final class KeyValuePair {
        public final HeaderKey _key;
        public final AMQTypedValue _value;
        private final int _hashCode;

        public KeyValuePair(HeaderKey key, AMQTypedValue value) {
            this._key = key;
            this._value = value;
            int hash = 1 + 31 * this._key.hashCode();
            if (this._value != null) {
                hash += this._value.hashCode();
            }
            this._hashCode = hash;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object o) {
            assert (o != null);
            assert (o instanceof KeyValuePair);
            KeyValuePair other = (KeyValuePair)o;
            return this._key == other._key && (this._value == null ? other._value == null : this._value.equals((Object)other._value));
        }

        public String toString() {
            return "{" + this._key + " -> " + this._value + "}";
        }
    }
}

