/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.federation;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.configuration.ConfiguredObject;
import org.apache.qpid.server.configuration.ConnectionConfig;
import org.apache.qpid.server.configuration.ConnectionConfigType;
import org.apache.qpid.server.configuration.LinkConfig;
import org.apache.qpid.server.configuration.LinkConfigType;
import org.apache.qpid.server.federation.Bridge;
import org.apache.qpid.server.transport.ServerSession;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.Binary;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionException;
import org.apache.qpid.transport.ConnectionListener;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionDelegate;
import org.apache.qpid.transport.TransportException;

public class BrokerLink
implements LinkConfig,
ConnectionListener {
    private static final int CORE_POOL_SIZE = 4;
    private static final ScheduledThreadPoolExecutor _threadPool = new ScheduledThreadPoolExecutor(4);
    private final String _transport;
    private final String _host;
    private final int _port;
    private final String _remoteVhost;
    private final boolean _durable;
    private final String _authMechanism;
    private final String _username;
    private final String _password;
    private final VirtualHost _virtualHost;
    private UUID _id;
    private AtomicBoolean _closing = new AtomicBoolean();
    private final long _createTime = System.currentTimeMillis();
    private Connection _qpidConnection;
    private AtomicReference<Thread> _executor = new AtomicReference();
    private AtomicInteger _bridgeId = new AtomicInteger();
    private final ConcurrentHashMap<Bridge, Bridge> _bridges = new ConcurrentHashMap();
    private final ConcurrentHashMap<Bridge, Bridge> _activeBridges = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<Bridge> _pendingBridges = new ConcurrentLinkedQueue();
    private String _remoteFederationTag;
    private ConnectionConfig _connectionConfig;
    private ConnectionException _exception;
    private String _lastErrorMessage;
    private int _retryDelay = 1;
    private final Runnable _makeConnectionTask = new Runnable(){

        public void run() {
            BrokerLink.this.doMakeConnection();
        }
    };
    private volatile State _state = State.DOWN;
    private static final AtomicReferenceFieldUpdater<BrokerLink, State> _stateUpdater = AtomicReferenceFieldUpdater.newUpdater(BrokerLink.class, State.class, "_state");

    public BrokerLink(VirtualHost virtualHost, String transport, String host, int port, String remoteVhost, boolean durable, String authMechanism, String username, String password) {
        this._virtualHost = virtualHost;
        this._transport = transport;
        this._host = host;
        this._port = port;
        this._remoteVhost = remoteVhost;
        this._durable = durable;
        this._authMechanism = authMechanism;
        this._username = username;
        this._password = password;
        this._id = virtualHost.getConfigStore().createId();
        this._qpidConnection = new Connection();
        this._connectionConfig = new ConnectionConfigAdapter();
        this._qpidConnection.addConnectionListener((ConnectionListener)this);
        this.makeConnection();
    }

    private final boolean updateState(State expected, State newState) {
        return _stateUpdater.compareAndSet(this, expected, newState);
    }

    private void makeConnection() {
        _threadPool.execute(this._makeConnectionTask);
    }

    private void doMakeConnection() {
        if (this.updateState(State.DOWN, State.ESTABLISHING)) {
            try {
                this._qpidConnection.connect(this._host, this._port, this._remoteVhost, this._username, this._password, "ssl".equals(this._transport), this._authMechanism);
                Map serverProps = this._qpidConnection.getServerProperties();
                this._remoteFederationTag = (String)serverProps.get("qpid.federation_tag");
                if (this._remoteFederationTag == null) {
                    this._remoteFederationTag = UUID.fromString(this._transport + ":" + this._host + ":" + this._port).toString();
                }
                this._qpidConnection.setSessionFactory((Connection.SessionFactory)new SessionFactory());
                this._qpidConnection.setAuthorizationID(this._username == null ? "" : this._username);
                this.updateState(State.ESTABLISHING, State.OPERATIONAL);
                this._retryDelay = 1;
                for (Bridge bridge : this._bridges.values()) {
                    if (this._state == State.OPERATIONAL) {
                        this.addBridge(bridge);
                        continue;
                    }
                    break;
                }
            }
            catch (TransportException e) {
                this._lastErrorMessage = e.getMessage();
                if (this._retryDelay < 60) {
                    this._retryDelay <<= 1;
                }
                this.updateState(State.ESTABLISHING, State.DOWN);
                this._activeBridges.clear();
                this.scheduleConnectionRetry();
            }
        }
    }

    private void scheduleConnectionRetry() {
        if (this._state != State.DELETED) {
            _threadPool.schedule(this._makeConnectionTask, (long)this._retryDelay, TimeUnit.SECONDS);
        }
    }

    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    public String getTransport() {
        return this._transport;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getRemoteVhost() {
        return this._remoteVhost;
    }

    public UUID getId() {
        return this._id;
    }

    public LinkConfigType getConfigType() {
        return LinkConfigType.getInstance();
    }

    public ConfiguredObject getParent() {
        return this.getVirtualHost();
    }

    public boolean isDurable() {
        return this._durable;
    }

    public String getAuthMechanism() {
        return this._authMechanism;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BrokerLink that = (BrokerLink)o;
        if (this._port != that._port) {
            return false;
        }
        if (this._host != null ? !this._host.equals(that._host) : that._host != null) {
            return false;
        }
        if (this._remoteVhost != null ? !this._remoteVhost.equals(that._remoteVhost) : that._remoteVhost != null) {
            return false;
        }
        return !(this._transport != null ? !this._transport.equals(that._transport) : that._transport != null);
    }

    public int hashCode() {
        int result = this._transport != null ? this._transport.hashCode() : 0;
        result = 31 * result + (this._host != null ? this._host.hashCode() : 0);
        result = 31 * result + this._port;
        result = 31 * result + (this._remoteVhost != null ? this._remoteVhost.hashCode() : 0);
        return result;
    }

    public void close() {
        if (this._closing.compareAndSet(false, true)) {
            for (Bridge bridge : this._bridges.values()) {
                bridge.close();
            }
            this._bridges.clear();
            this._virtualHost.removeBrokerConnection(this);
        }
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public void createBridge(boolean durable, boolean dynamic, boolean srcIsQueue, boolean srcIsLocal, String src, String dest, String key, String tag, String excludes) {
        Bridge bridge;
        if (!this._closing.get() && this._bridges.putIfAbsent(bridge = new Bridge(this, this._bridgeId.incrementAndGet(), durable, dynamic, srcIsQueue, srcIsLocal, src, dest, key, tag, excludes), bridge) == null) {
            this.addBridge(bridge);
        }
    }

    private void addBridge(Bridge bridge) {
        this.getConfigStore().addConfiguredObject(bridge);
        if (this._state == State.OPERATIONAL && this._activeBridges.putIfAbsent(bridge, bridge) == null) {
            Session session = this._qpidConnection.createSession("Bridge(" + (bridge.isDurable() ? "durable" : "transient") + "," + (bridge.isDynamic() ? "dynamic" : "static") + "," + (bridge.isQueueBridge() ? "queue" : "exchange") + "," + (bridge.isLocalSource() ? "local-src" : "remote-src") + ",[Source: '" + bridge.getSource() + "']" + ",[Destination: '" + bridge.getDestination() + "']" + ",[Key: '" + bridge.getKey() + "']" + ",[Tag: '" + bridge.getTag() + "']" + ".[Excludes: '" + bridge.getExcludes() + "'])");
            bridge.setSession(session);
            if (this._closing.get()) {
                bridge.close();
            }
        }
    }

    public void opened(Connection connection) {
    }

    public void exception(Connection connection, ConnectionException exception) {
        this._exception = exception;
        this._lastErrorMessage = exception.getMessage();
    }

    public void closed(Connection connection) {
        State currentState = this._state;
        if (currentState != State.DOWN && currentState != State.DELETED && this.updateState(currentState, State.DOWN)) {
            this.scheduleConnectionRetry();
        }
    }

    public ConfigStore getConfigStore() {
        return this.getVirtualHost().getConfigStore();
    }

    public String getFederationTag() {
        return this.getVirtualHost().getFederationTag();
    }

    public String getRemoteFederationTag() {
        return this._remoteFederationTag;
    }

    private class SessionFactory
    implements Connection.SessionFactory {
        private SessionFactory() {
        }

        public Session newSession(Connection conn, Binary name, long expiry) {
            return new ServerSession(conn, new SessionDelegate(), name, expiry, BrokerLink.this._connectionConfig);
        }
    }

    private class ConnectionConfigAdapter
    implements ConnectionConfig {
        private long _adapterCreateTime = System.currentTimeMillis();
        private UUID _id = BrokerLink.this.getConfigStore().createId();

        private ConnectionConfigAdapter() {
        }

        public VirtualHost getVirtualHost() {
            return BrokerLink.this.getVirtualHost();
        }

        public String getAddress() {
            return BrokerLink.this._host + ":" + BrokerLink.this._port;
        }

        public Boolean isIncoming() {
            return false;
        }

        public Boolean isSystemConnection() {
            return true;
        }

        public Boolean isFederationLink() {
            return true;
        }

        public String getAuthId() {
            return BrokerLink.this._username;
        }

        public String getRemoteProcessName() {
            return null;
        }

        public Integer getRemotePID() {
            return null;
        }

        public Integer getRemoteParentPID() {
            return null;
        }

        public ConfigStore getConfigStore() {
            return this.getVirtualHost().getConfigStore();
        }

        public UUID getId() {
            return this._id;
        }

        public ConnectionConfigType getConfigType() {
            return ConnectionConfigType.getInstance();
        }

        public ConfiguredObject getParent() {
            return this.getVirtualHost();
        }

        public boolean isDurable() {
            return false;
        }

        public long getCreateTime() {
            return this._adapterCreateTime;
        }

        public Boolean isShadow() {
            return false;
        }

        public void mgmtClose() {
            BrokerLink.this._connectionConfig.mgmtClose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        OPERATIONAL,
        DOWN,
        ESTABLISHING,
        DELETED;

    }
}

