/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.qpid.server.filter.Expression;
import org.apache.qpid.server.queue.Filterable;

public class PropertyExpression
implements Expression {
    private static final int NON_PERSISTENT = 1;
    private static final int PERSISTENT = 2;
    private static final int DEFAULT_PRIORITY = 4;
    private static final Logger _logger = Logger.getLogger(PropertyExpression.class);
    private static final HashMap<String, Expression> JMS_PROPERTY_EXPRESSIONS = new HashMap();
    private final String name;
    private final Expression jmsPropertyExpression;

    public boolean outerTest() {
        return false;
    }

    public PropertyExpression(String name) {
        JMS_PROPERTY_EXPRESSIONS.put("JMSDestination", new Expression(){

            public Object evaluate(Filterable message) {
                return null;
            }
        });
        JMS_PROPERTY_EXPRESSIONS.put("JMSReplyTo", new ReplyToExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSType", new TypeExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSDeliveryMode", new DeliveryModeExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSPriority", new PriorityExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSMessageID", new MessageIDExpression());
        JMS_PROPERTY_EXPRESSIONS.put("AMQMessageID", new MessageIDExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSTimestamp", new TimestampExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSCorrelationID", new CorrelationIdExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSExpiration", new ExpirationExpression());
        JMS_PROPERTY_EXPRESSIONS.put("JMSRedelivered", new Expression(){

            public Object evaluate(Filterable message) {
                return message.isRedelivered();
            }
        });
        this.name = name;
        this.jmsPropertyExpression = JMS_PROPERTY_EXPRESSIONS.get(name);
    }

    public Object evaluate(Filterable message) {
        if (this.jmsPropertyExpression != null) {
            return this.jmsPropertyExpression.evaluate(message);
        }
        return message.getMessageHeader().getHeader(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.name.equals(((PropertyExpression)o).name);
    }

    private static class ExpirationExpression
    implements Expression {
        private ExpirationExpression() {
        }

        public Object evaluate(Filterable message) {
            long expiration = message.getMessageHeader().getExpiration();
            return expiration;
        }
    }

    private static class CorrelationIdExpression
    implements Expression {
        private CorrelationIdExpression() {
        }

        public Object evaluate(Filterable message) {
            String correlationId = message.getMessageHeader().getCorrelationId();
            return correlationId;
        }
    }

    private static class TimestampExpression
    implements Expression {
        private TimestampExpression() {
        }

        public Object evaluate(Filterable message) {
            long timestamp = message.getMessageHeader().getTimestamp();
            return timestamp;
        }
    }

    private static class MessageIDExpression
    implements Expression {
        private MessageIDExpression() {
        }

        public Object evaluate(Filterable message) {
            String messageId = message.getMessageHeader().getMessageId();
            return messageId;
        }
    }

    private static class PriorityExpression
    implements Expression {
        private PriorityExpression() {
        }

        public Object evaluate(Filterable message) {
            byte priority = message.getMessageHeader().getPriority();
            return (int)priority;
        }
    }

    private static class DeliveryModeExpression
    implements Expression {
        private DeliveryModeExpression() {
        }

        public Object evaluate(Filterable message) {
            int mode;
            int n = mode = message.isPersistent() ? 2 : 1;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("JMSDeliveryMode is :" + mode));
            }
            return mode;
        }
    }

    private static class TypeExpression
    implements Expression {
        private TypeExpression() {
        }

        public Object evaluate(Filterable message) {
            String type = message.getMessageHeader().getType();
            return type;
        }
    }

    private static class ReplyToExpression
    implements Expression {
        private ReplyToExpression() {
        }

        public Object evaluate(Filterable message) {
            String replyTo = message.getMessageHeader().getReplyTo();
            return replyTo;
        }
    }
}

