/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.queue.Filterable;

public class SimpleFilterManager
implements FilterManager {
    private final Logger _logger = Logger.getLogger(SimpleFilterManager.class);
    private final ConcurrentLinkedQueue<MessageFilter> _filters;
    private String _toString = "";

    public SimpleFilterManager() {
        this._logger.debug((Object)"Creating SimpleFilterManager");
        this._filters = new ConcurrentLinkedQueue();
    }

    public void add(MessageFilter filter) {
        this._filters.add(filter);
        this.updateStringValue();
    }

    public void remove(MessageFilter filter) {
        this._filters.remove(filter);
        this.updateStringValue();
    }

    public boolean allAllow(Filterable msg) {
        for (MessageFilter filter : this._filters) {
            if (filter.matches(msg)) continue;
            return false;
        }
        return true;
    }

    public boolean hasFilters() {
        return !this._filters.isEmpty();
    }

    public String toString() {
        return this._toString;
    }

    private void updateStringValue() {
        StringBuilder toString = new StringBuilder();
        for (MessageFilter filter : this._filters) {
            toString.append(filter.toString());
            toString.append(",");
        }
        if (this._filters.size() > 0) {
            toString.deleteCharAt(toString.length() - 1);
        }
        this._toString = toString.toString();
    }
}

