/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.ChannelOpenBody;
import org.apache.qpid.framing.ChannelOpenOkBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.amqp_0_9.MethodRegistry_0_9;
import org.apache.qpid.framing.amqp_0_91.MethodRegistry_0_91;
import org.apache.qpid.framing.amqp_8_0.MethodRegistry_8_0;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelOpenHandler
implements StateAwareMethodListener<ChannelOpenBody> {
    private static final Logger _logger = Logger.getLogger(ChannelOpenHandler.class);
    private static ChannelOpenHandler _instance = new ChannelOpenHandler();

    public static ChannelOpenHandler getInstance() {
        return _instance;
    }

    private ChannelOpenHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ChannelOpenBody body, int channelId) throws AMQException {
        ChannelOpenOkBody response;
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHost virtualHost = session.getVirtualHost();
        if (virtualHost == null) {
            throw new AMQException(AMQConstant.COMMAND_INVALID, "Virtualhost has not yet been set. ConnectionOpen has not been called.", null);
        }
        _logger.info((Object)("Connecting to: " + virtualHost.getName()));
        AMQChannel channel = new AMQChannel(session, channelId, virtualHost.getMessageStore());
        session.addChannel(channel);
        ProtocolVersion pv = session.getProtocolVersion();
        if (pv.equals((Object)ProtocolVersion.v8_0)) {
            MethodRegistry_8_0 methodRegistry = (MethodRegistry_8_0)MethodRegistry.getMethodRegistry((ProtocolVersion)ProtocolVersion.v8_0);
            response = methodRegistry.createChannelOpenOkBody();
        } else if (pv.equals((Object)ProtocolVersion.v0_9)) {
            MethodRegistry_0_9 methodRegistry = (MethodRegistry_0_9)MethodRegistry.getMethodRegistry((ProtocolVersion)ProtocolVersion.v0_9);
            UUID uuid = UUID.randomUUID();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(output);
            try {
                dataOut.writeLong(uuid.getMostSignificantBits());
                dataOut.writeLong(uuid.getLeastSignificantBits());
                dataOut.flush();
                dataOut.close();
            }
            catch (IOException e) {
                throw new RuntimeException("I/O exception when writing to byte array", e);
            }
            byte[] channelName = output.toByteArray();
            response = methodRegistry.createChannelOpenOkBody(channelName);
        } else if (pv.equals((Object)ProtocolVersion.v0_91)) {
            MethodRegistry_0_91 methodRegistry = (MethodRegistry_0_91)MethodRegistry.getMethodRegistry((ProtocolVersion)ProtocolVersion.v0_91);
            UUID uuid = UUID.randomUUID();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            DataOutputStream dataOut = new DataOutputStream(output);
            try {
                dataOut.writeLong(uuid.getMostSignificantBits());
                dataOut.writeLong(uuid.getLeastSignificantBits());
                dataOut.flush();
                dataOut.close();
            }
            catch (IOException e) {
                throw new RuntimeException("I/O exception when writing to byte array", e);
            }
            byte[] channelName = output.toByteArray();
            response = methodRegistry.createChannelOpenOkBody(channelName);
        } else {
            throw new AMQException(AMQConstant.INTERNAL_ERROR, "Got channel open for protocol version not catered for: " + pv, null);
        }
        session.writeFrame((AMQDataBlock)response.generateFrame(channelId));
    }
}

