/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQConnectionException;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQUnknownExchangeType;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeDeclareHandler
implements StateAwareMethodListener<ExchangeDeclareBody> {
    private static final Logger _logger = Logger.getLogger(ExchangeDeclareHandler.class);
    private static final ExchangeDeclareHandler _instance = new ExchangeDeclareHandler();

    public static ExchangeDeclareHandler getInstance() {
        return _instance;
    }

    private ExchangeDeclareHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void methodReceived(AMQStateManager stateManager, ExchangeDeclareBody body, int channelId) throws AMQException {
        session = stateManager.getProtocolSession();
        virtualHost = session.getVirtualHost();
        exchangeRegistry = virtualHost.getExchangeRegistry();
        exchangeFactory = virtualHost.getExchangeFactory();
        if (ExchangeDeclareHandler._logger.isDebugEnabled()) {
            ExchangeDeclareHandler._logger.debug((Object)("Request to declare exchange of type " + body.getType() + " with name " + body.getExchange()));
        }
        var8_8 = exchangeRegistry;
        synchronized (var8_8) {
            exchange = exchangeRegistry.getExchange(body.getExchange());
            if (exchange == null) {
                if (body.getPassive() && (body.getType() == null || body.getType().length() == 0)) {
                    throw body.getChannelException(AMQConstant.NOT_FOUND, "Unknown exchange: " + body.getExchange());
                }
                try {
                    exchange = exchangeFactory.createExchange(body.getExchange() == null ? null : body.getExchange().intern(), body.getType() == null ? null : body.getType().intern(), body.getDurable(), body.getPassive(), body.getTicket());
                    exchangeRegistry.registerExchange(exchange);
                    if (!exchange.isDurable()) ** GOTO lbl27
                    virtualHost.getDurableConfigurationStore().createExchange(exchange);
                }
                catch (AMQUnknownExchangeType e) {
                    throw body.getConnectionException(AMQConstant.COMMAND_INVALID, "Unknown exchange: " + body.getExchange(), (Throwable)e);
                }
            } else if (!exchange.getTypeShortString().equals(body.getType())) {
                throw new AMQConnectionException(AMQConstant.NOT_ALLOWED, "Attempt to redeclare exchange: " + body.getExchange() + " of type " + exchange.getTypeShortString() + " to " + body.getType() + ".", body.getClazz(), body.getMethod(), body.getMajor(), body.getMinor(), null);
            }
        }
lbl27:
        // 3 sources

        if (!body.getNowait()) {
            methodRegistry = session.getMethodRegistry();
            responseBody = methodRegistry.createExchangeDeclareOkBody();
            session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
        }
    }
}

