/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.actors;

import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.RootMessageLogger;

public abstract class AbstractActor
implements LogActor {
    public final String _msgPrefix = System.getProperty("qpid.logging.prefix", "");
    protected RootMessageLogger _rootLogger;

    public AbstractActor(RootMessageLogger rootLogger) {
        if (rootLogger == null) {
            throw new NullPointerException("RootMessageLogger cannot be null");
        }
        this._rootLogger = rootLogger;
    }

    public void message(LogSubject subject, LogMessage message) {
        if (this._rootLogger.isMessageEnabled(this, subject, message.getLogHierarchy())) {
            this._rootLogger.rawMessage(this._msgPrefix + this.getLogMessage() + subject.toLogString() + message, message.getLogHierarchy());
        }
    }

    public void message(LogMessage message) {
        if (this._rootLogger.isMessageEnabled(this, message.getLogHierarchy())) {
            this._rootLogger.rawMessage(this._msgPrefix + this.getLogMessage() + message, message.getLogHierarchy());
        }
    }

    public RootMessageLogger getRootMessageLogger() {
        return this._rootLogger;
    }

    public String toString() {
        return this.getLogMessage();
    }

    public abstract String getLogMessage();
}

