/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management;

import javax.management.JMException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.management.ManagedObjectRegistry;
import org.apache.qpid.server.registry.ApplicationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultManagedObject
extends StandardMBean
implements ManagedObject {
    private Class<?> _managementInterface;
    private String _typeName;

    protected DefaultManagedObject(Class<?> managementInterface, String typeName) throws NotCompliantMBeanException {
        super(managementInterface);
        this._managementInterface = managementInterface;
        this._typeName = typeName;
    }

    @Override
    public String getType() {
        return this._typeName;
    }

    @Override
    public Class<?> getManagementInterface() {
        return this._managementInterface;
    }

    @Override
    public ManagedObject getParentObject() {
        return null;
    }

    @Override
    public void register() throws JMException {
        this.getManagedObjectRegistry().registerObject(this);
    }

    protected ManagedObjectRegistry getManagedObjectRegistry() {
        return ApplicationRegistry.getInstance().getManagedObjectRegistry();
    }

    @Override
    public void unregister() throws AMQException {
        try {
            this.getManagedObjectRegistry().unregisterObject(this);
        }
        catch (JMException e) {
            throw new AMQException("Error unregistering managed object: " + this + ": " + e, (Throwable)e);
        }
    }

    public String toString() {
        return this.getObjectInstanceName() + "[" + this.getType() + "]";
    }

    @Override
    public ObjectName getObjectName() throws MalformedObjectNameException {
        String name = this.getObjectInstanceName();
        StringBuffer objectName = new StringBuffer("org.apache.qpid");
        objectName.append(":type=");
        objectName.append(this.getHierarchicalType(this));
        objectName.append(",");
        objectName.append(this.getHierarchicalName(this));
        objectName.append("name=").append(name);
        return new ObjectName(objectName.toString());
    }

    protected ObjectName getObjectNameForSingleInstanceMBean() throws MalformedObjectNameException {
        StringBuffer objectName = new StringBuffer("org.apache.qpid");
        objectName.append(":type=");
        objectName.append(this.getHierarchicalType(this));
        String hierarchyName = this.getHierarchicalName(this);
        if (hierarchyName != null) {
            objectName.append(",");
            objectName.append(hierarchyName.substring(0, hierarchyName.lastIndexOf(",")));
        }
        return new ObjectName(objectName.toString());
    }

    protected String getHierarchicalType(ManagedObject obj) {
        if (obj.getParentObject() != null) {
            String parentType = this.getHierarchicalType(obj.getParentObject()).toString();
            return parentType + "." + obj.getType();
        }
        return obj.getType();
    }

    protected String getHierarchicalName(ManagedObject obj) {
        if (obj.getParentObject() != null) {
            String parentName = obj.getParentObject().getType() + "=" + obj.getParentObject().getObjectInstanceName() + "," + this.getHierarchicalName(obj.getParentObject());
            return parentName;
        }
        return "";
    }
}

