/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.MBeanServerForwarder;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.apache.qpid.server.logging.actors.ManagementActor;
import org.apache.qpid.server.logging.messages.ManagementConsoleMessages;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.access.Operation;

public class MBeanInvocationHandlerImpl
implements InvocationHandler,
NotificationListener {
    private static final Logger _logger = Logger.getLogger(MBeanInvocationHandlerImpl.class);
    public static final String ADMIN = "admin";
    public static final String READWRITE = "readwrite";
    public static final String READONLY = "readonly";
    private static final String DELEGATE = "JMImplementation:type=MBeanServerDelegate";
    private MBeanServer _mbs;
    private static Properties _userRoles = new Properties();
    private static ManagementActor _logActor;

    public static MBeanServerForwarder newProxyInstance() {
        MBeanInvocationHandlerImpl handler = new MBeanInvocationHandlerImpl();
        Class[] interfaces = new Class[]{MBeanServerForwarder.class};
        _logActor = new ManagementActor(ApplicationRegistry.getInstance().getRootMessageLogger());
        Object proxy = Proxy.newProxyInstance(MBeanServerForwarder.class.getClassLoader(), interfaces, (InvocationHandler)handler);
        return (MBeanServerForwarder)MBeanServerForwarder.class.cast(proxy);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = this.getMethodName(method, args);
        if (methodName.equals("getMBeanServer")) {
            return this._mbs;
        }
        if (methodName.equals("setMBeanServer")) {
            if (args[0] == null) {
                throw new IllegalArgumentException("Null MBeanServer");
            }
            if (this._mbs != null) {
                throw new IllegalArgumentException("MBeanServer object already initialized");
            }
            this._mbs = (MBeanServer)args[0];
            return null;
        }
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        try {
            if (subject == null) {
                return method.invoke((Object)this._mbs, args);
            }
            if (args == null || DELEGATE.equals(args[0])) {
                return method.invoke((Object)this._mbs, args);
            }
            if (methodName.equals("createMBean") || methodName.equals("unregisterMBean")) {
                _logger.debug((Object)"User trying to create or unregister an MBean");
                throw new SecurityException("Access denied: " + methodName);
            }
            if (methodName.equals("queryNames")) {
                return method.invoke((Object)this._mbs, args);
            }
            Set<JMXPrincipal> principals = subject.getPrincipals(JMXPrincipal.class);
            if (principals == null || principals.isEmpty()) {
                throw new SecurityException("Access denied: no principal");
            }
            Principal principal = principals.iterator().next();
            SecurityManager.setThreadPrincipal(principal);
            String type = this.getType(method, args);
            String vhost = this.getVirtualHost(method, args);
            int impact = this.getImpact(method, args);
            SecurityManager security = vhost == null ? ApplicationRegistry.getInstance().getSecurityManager() : ApplicationRegistry.getInstance().getVirtualHostRegistry().getVirtualHost(vhost).getSecurityManager();
            if (this.isAccessMethod(methodName) || impact == 0) {
                if (!security.authoriseMethod(Operation.ACCESS, type, methodName)) {
                    throw new SecurityException("Permission denied: Access " + methodName);
                }
            } else if (this.isUpdateMethod(methodName)) {
                if (!security.authoriseMethod(Operation.UPDATE, type, methodName)) {
                    throw new SecurityException("Permission denied: Update " + methodName);
                }
            } else if (!security.authoriseMethod(Operation.EXECUTE, type, methodName)) {
                throw new SecurityException("Permission denied: Execute " + methodName);
            }
            return method.invoke((Object)this._mbs, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private String getType(Method method, Object[] args) {
        if (args[0] instanceof ObjectName) {
            ObjectName object = (ObjectName)args[0];
            String type = object.getKeyProperty("type");
            return type;
        }
        return null;
    }

    private String getVirtualHost(Method method, Object[] args) {
        if (args[0] instanceof ObjectName) {
            ObjectName object = (ObjectName)args[0];
            String vhost = object.getKeyProperty("VirtualHost");
            if (vhost != null) {
                try {
                    vhost = ObjectName.unquote(vhost);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            return vhost;
        }
        return null;
    }

    private String getMethodName(Method method, Object[] args) {
        String methodName = method.getName();
        if (args != null && args.length >= 1 && args[0] instanceof ObjectName) {
            if (methodName.equals("getAttribute")) {
                methodName = "get" + (String)args[1];
            } else if (methodName.equals("setAttribute")) {
                methodName = "set" + ((Attribute)args[1]).getName();
            } else if (methodName.equals("invoke")) {
                methodName = (String)args[1];
            }
        }
        return methodName;
    }

    private int getImpact(Method method, Object[] args) {
        if (args[0] instanceof ObjectName && method.getName().equals("invoke")) {
            String mbeanMethod;
            String string = mbeanMethod = args.length > 1 ? (String)args[1] : null;
            if (mbeanMethod == null) {
                return -1;
            }
            try {
                MBeanInfo mbeanInfo = this._mbs.getMBeanInfo((ObjectName)args[0]);
                if (mbeanInfo != null) {
                    MBeanOperationInfo[] opInfos;
                    for (MBeanOperationInfo opInfo : opInfos = mbeanInfo.getOperations()) {
                        if (!opInfo.getName().equals(mbeanMethod)) continue;
                        return opInfo.getImpact();
                    }
                }
            }
            catch (JMException ex) {
                ex.printStackTrace();
            }
        }
        return -1;
    }

    private boolean isAccessMethod(String methodName) {
        return methodName.startsWith("query") || methodName.startsWith("get") || methodName.startsWith("is");
    }

    private boolean isUpdateMethod(String methodName) {
        return methodName.startsWith("set");
    }

    public void handleNotification(Notification notification, Object handback) {
        assert (notification instanceof JMXConnectionNotification);
        String[] connectionData = ((JMXConnectionNotification)notification).getConnectionId().split(" ");
        String user = connectionData[1];
        if (notification.getType().equals("jmx.remote.connection.opened")) {
            _logActor.message(ManagementConsoleMessages.OPEN(user));
        } else if (notification.getType().equals("jmx.remote.connection.closed") || notification.getType().equals("jmx.remote.connection.failed")) {
            _logActor.message(ManagementConsoleMessages.CLOSE());
        }
    }
}

