/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import java.util.Set;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.message.AMQMessageHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentHeaderBodyAdapter
implements AMQMessageHeader {
    private final ContentHeaderBody _contentHeaderBody;

    public ContentHeaderBodyAdapter(ContentHeaderBody contentHeaderBody) {
        this._contentHeaderBody = contentHeaderBody;
    }

    private BasicContentHeaderProperties getProperties() {
        return (BasicContentHeaderProperties)this._contentHeaderBody.properties;
    }

    @Override
    public String getCorrelationId() {
        return this.getProperties().getCorrelationIdAsString();
    }

    @Override
    public long getExpiration() {
        return this.getProperties().getExpiration();
    }

    @Override
    public String getMessageId() {
        return this.getProperties().getMessageIdAsString();
    }

    @Override
    public String getMimeType() {
        return this.getProperties().getContentTypeAsString();
    }

    @Override
    public String getEncoding() {
        return this.getProperties().getEncodingAsString();
    }

    @Override
    public byte getPriority() {
        return this.getProperties().getPriority();
    }

    @Override
    public long getTimestamp() {
        return this.getProperties().getTimestamp();
    }

    @Override
    public String getType() {
        return this.getProperties().getTypeAsString();
    }

    @Override
    public String getReplyTo() {
        return this.getProperties().getReplyToAsString();
    }

    @Override
    public String getReplyToExchange() {
        return this.getReplyTo();
    }

    @Override
    public String getReplyToRoutingKey() {
        return this.getReplyTo();
    }

    @Override
    public Object getHeader(String name) {
        FieldTable ft = this.getProperties().getHeaders();
        return ft.get(name);
    }

    @Override
    public boolean containsHeaders(Set<String> names) {
        FieldTable ft = this.getProperties().getHeaders();
        for (String name : names) {
            if (ft.containsKey(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsHeader(String name) {
        FieldTable ft = this.getProperties().getHeaders();
        return ft.containsKey(name);
    }
}

