/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.MessageTransferHeader;
import org.apache.qpid.server.store.MessageMetaDataType;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageDeliveryMode;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.codec.BBDecoder;
import org.apache.qpid.transport.codec.BBEncoder;

public class MessageMetaData_0_10
implements StorableMessageMetaData {
    private Header _header;
    private DeliveryProperties _deliveryProps;
    private MessageProperties _messageProps;
    private MessageTransferHeader _messageHeader;
    private long _arrivalTime;
    private int _bodySize;
    private volatile SoftReference<ByteBuffer> _body;
    private static final int ENCODER_SIZE = 65536;
    public static final MessageMetaDataType.Factory<MessageMetaData_0_10> FACTORY = new MetaDataFactory();
    private volatile ByteBuffer _encoded;

    public MessageMetaData_0_10(MessageTransfer xfr) {
        this(xfr.getHeader(), xfr.getBodySize(), xfr.getBody(), System.currentTimeMillis());
    }

    private MessageMetaData_0_10(Header header, int bodySize, long arrivalTime) {
        this(header, bodySize, null, arrivalTime);
    }

    private MessageMetaData_0_10(Header header, int bodySize, ByteBuffer xfrBody, long arrivalTime) {
        this._header = header;
        if (this._header != null) {
            this._deliveryProps = (DeliveryProperties)this._header.get(DeliveryProperties.class);
            this._messageProps = (MessageProperties)this._header.get(MessageProperties.class);
        } else {
            this._deliveryProps = null;
            this._messageProps = null;
        }
        this._messageHeader = new MessageTransferHeader(this._deliveryProps, this._messageProps);
        this._arrivalTime = arrivalTime;
        this._bodySize = bodySize;
        if (xfrBody == null) {
            this._body = null;
        } else {
            ByteBuffer body = ByteBuffer.allocate(this._bodySize);
            body.put(xfrBody);
            body.flip();
            this._body = new SoftReference<ByteBuffer>(body);
        }
    }

    public MessageMetaDataType getType() {
        return MessageMetaDataType.META_DATA_0_10;
    }

    public int getStorableSize() {
        ByteBuffer buf = this._encoded;
        if (buf == null) {
            this._encoded = buf = this.encodeAsBuffer();
        }
        return buf.limit();
    }

    private ByteBuffer encodeAsBuffer() {
        BBEncoder encoder = new BBEncoder(65536);
        encoder.writeInt64(this._arrivalTime);
        encoder.writeInt32(this._bodySize);
        Struct[] headers = this._header == null ? new Struct[]{} : this._header.getStructs();
        encoder.writeInt32(headers.length);
        for (Struct header : headers) {
            encoder.writeStruct32(header);
        }
        ByteBuffer buf = encoder.buffer();
        return buf;
    }

    public int writeToBuffer(int offsetInMetaData, ByteBuffer dest) {
        ByteBuffer buf = this._encoded;
        if (buf == null) {
            this._encoded = buf = this.encodeAsBuffer();
        }
        buf = buf.duplicate();
        buf.position(offsetInMetaData);
        if (dest.remaining() < buf.limit()) {
            buf.limit(dest.remaining());
        }
        dest.put(buf);
        return buf.limit();
    }

    public int getContentSize() {
        return this._bodySize;
    }

    public boolean isPersistent() {
        return this._deliveryProps == null ? false : this._deliveryProps.getDeliveryMode() == MessageDeliveryMode.PERSISTENT;
    }

    public String getRoutingKey() {
        return this._deliveryProps == null ? null : this._deliveryProps.getRoutingKey();
    }

    public AMQMessageHeader getMessageHeader() {
        return this._messageHeader;
    }

    public long getSize() {
        return this._bodySize;
    }

    public boolean isImmediate() {
        return this._deliveryProps != null && this._deliveryProps.getImmediate();
    }

    public long getExpiration() {
        return this._deliveryProps == null ? 0L : this._deliveryProps.getExpiration();
    }

    public long getArrivalTime() {
        return this._arrivalTime;
    }

    public Header getHeader() {
        return this._header;
    }

    public ByteBuffer getBody() {
        ByteBuffer body = this._body == null ? null : this._body.get();
        return body;
    }

    public void setBody(ByteBuffer body) {
        this._body = new SoftReference<ByteBuffer>(body);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetaDataFactory
    implements MessageMetaDataType.Factory<MessageMetaData_0_10> {
        private MetaDataFactory() {
        }

        @Override
        public MessageMetaData_0_10 createMetaData(ByteBuffer buf) {
            BBDecoder decoder = new BBDecoder();
            decoder.init(buf);
            long arrivalTime = decoder.readInt64();
            int bodySize = decoder.readInt32();
            int headerCount = decoder.readInt32();
            Struct[] headers = new Struct[headerCount];
            for (int i = 0; i < headerCount; ++i) {
                headers[i] = decoder.readStruct32();
            }
            Header header = new Header(headers);
            return new MessageMetaData_0_10(header, bodySize, arrivalTime);
        }
    }
}

