/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.protocol.ProtocolEngine;
import org.apache.qpid.protocol.ProtocolEngineFactory;
import org.apache.qpid.server.protocol.MultiVersionProtocolEngine;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.transport.NetworkDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiVersionProtocolEngineFactory
implements ProtocolEngineFactory {
    private static final Set<VERSION> ALL_VERSIONS = new HashSet<VERSION>(Arrays.asList(VERSION.values()));
    private final IApplicationRegistry _appRegistry;
    private final String _fqdn;
    private final Set<VERSION> _supported;

    public MultiVersionProtocolEngineFactory() {
        this(1, "localhost", ALL_VERSIONS);
    }

    public MultiVersionProtocolEngineFactory(String fqdn, Set<VERSION> versions) {
        this(1, fqdn, versions);
    }

    public MultiVersionProtocolEngineFactory(String fqdn) {
        this(1, fqdn, ALL_VERSIONS);
    }

    public MultiVersionProtocolEngineFactory(int instance, String fqdn, Set<VERSION> supportedVersions) {
        this._appRegistry = ApplicationRegistry.getInstance(instance);
        this._fqdn = fqdn;
        this._supported = supportedVersions;
    }

    public ProtocolEngine newProtocolEngine(NetworkDriver networkDriver) {
        return new MultiVersionProtocolEngine(this._appRegistry, this._fqdn, this._supported, networkDriver);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VERSION {
        v0_8,
        v0_9,
        v0_9_1,
        v0_10;

    }
}

