/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueNotificationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NotificationCheck {
    MESSAGE_COUNT_ALERT{

        boolean notifyIfNecessary(ServerMessage msg, AMQQueue queue, QueueNotificationListener listener) {
            int msgCount;
            long maximumMessageCount = queue.getMaximumMessageCount();
            if (maximumMessageCount != 0L && (long)(msgCount = queue.getMessageCount()) >= maximumMessageCount) {
                listener.notifyClients(this, queue, msgCount + ": Maximum count on queue threshold (" + maximumMessageCount + ") breached.");
                return true;
            }
            return false;
        }
    }
    ,
    MESSAGE_SIZE_ALERT(true){

        boolean notifyIfNecessary(ServerMessage msg, AMQQueue queue, QueueNotificationListener listener) {
            long maximumMessageSize = queue.getMaximumMessageSize();
            if (maximumMessageSize != 0L) {
                long messageSize;
                long l = messageSize = msg == null ? 0L : msg.getSize();
                if (messageSize >= maximumMessageSize) {
                    listener.notifyClients(this, queue, messageSize + "b : Maximum message size threshold (" + maximumMessageSize + ") breached. [Message ID=" + msg.getMessageNumber() + "]");
                    return true;
                }
            }
            return false;
        }
    }
    ,
    QUEUE_DEPTH_ALERT{

        boolean notifyIfNecessary(ServerMessage msg, AMQQueue queue, QueueNotificationListener listener) {
            long queueDepth;
            long maximumQueueDepth = queue.getMaximumQueueDepth();
            if (maximumQueueDepth != 0L && (queueDepth = queue.getQueueDepth()) >= maximumQueueDepth) {
                listener.notifyClients(this, queue, (queueDepth >> 10) + "Kb : Maximum queue depth threshold (" + (maximumQueueDepth >> 10) + "Kb) breached.");
                return true;
            }
            return false;
        }
    }
    ,
    MESSAGE_AGE_ALERT{

        boolean notifyIfNecessary(ServerMessage msg, AMQQueue queue, QueueNotificationListener listener) {
            long maxMessageAge = queue.getMaximumMessageAge();
            if (maxMessageAge != 0L) {
                long currentTime = System.currentTimeMillis();
                long thresholdTime = currentTime - maxMessageAge;
                long firstArrivalTime = queue.getOldestMessageArrivalTime();
                if (firstArrivalTime < thresholdTime) {
                    long oldestAge = currentTime - firstArrivalTime;
                    listener.notifyClients(this, queue, oldestAge / 1000L + "s : Maximum age on queue threshold (" + maxMessageAge / 1000L + "s) breached.");
                    return true;
                }
            }
            return false;
        }
    };

    private final boolean _messageSpecific;

    private NotificationCheck() {
        this(false);
    }

    private NotificationCheck(boolean messageSpecific) {
        this._messageSpecific = messageSpecific;
    }

    public boolean isMessageSpecific() {
        return this._messageSpecific;
    }

    abstract boolean notifyIfNecessary(ServerMessage var1, AMQQueue var2, QueueNotificationListener var3);
}

