/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.message.MessageReference;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.InboundMessageAdapter;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.SimpleQueueEntryList;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;

public class QueueEntryImpl
implements QueueEntry {
    private static final Logger _log = Logger.getLogger(QueueEntryImpl.class);
    private final SimpleQueueEntryList _queueEntryList;
    private MessageReference _message;
    private Set<Subscription> _rejectedBy = null;
    private volatile QueueEntry.EntryState _state = AVAILABLE_STATE;
    private static final AtomicReferenceFieldUpdater<QueueEntryImpl, QueueEntry.EntryState> _stateUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueEntryImpl.class, QueueEntry.EntryState.class, "_state");
    private volatile Set<QueueEntry.StateChangeListener> _stateChangeListeners;
    private static final AtomicReferenceFieldUpdater<QueueEntryImpl, Set> _listenersUpdater = AtomicReferenceFieldUpdater.newUpdater(QueueEntryImpl.class, Set.class, "_stateChangeListeners");
    private static final AtomicLongFieldUpdater<QueueEntryImpl> _entryIdUpdater = AtomicLongFieldUpdater.newUpdater(QueueEntryImpl.class, "_entryId");
    private volatile long _entryId;
    volatile QueueEntryImpl _next;
    private static final int DELIVERED_TO_CONSUMER = 1;
    private static final int REDELIVERED = 2;
    private volatile int _deliveryState;

    QueueEntryImpl(SimpleQueueEntryList queueEntryList) {
        this(queueEntryList, null, Long.MIN_VALUE);
        this._state = DELETED_STATE;
    }

    public QueueEntryImpl(SimpleQueueEntryList queueEntryList, ServerMessage message, long entryId) {
        this._queueEntryList = queueEntryList;
        this._message = message == null ? null : message.newReference();
        _entryIdUpdater.set(this, entryId);
    }

    public QueueEntryImpl(SimpleQueueEntryList queueEntryList, ServerMessage message) {
        this._queueEntryList = queueEntryList;
        this._message = message == null ? null : message.newReference();
    }

    protected void setEntryId(long entryId) {
        _entryIdUpdater.set(this, entryId);
    }

    protected long getEntryId() {
        return this._entryId;
    }

    public AMQQueue getQueue() {
        return this._queueEntryList.getQueue();
    }

    public ServerMessage getMessage() {
        return this._message == null ? null : (ServerMessage)this._message.getMessage();
    }

    public long getSize() {
        return this.getMessage() == null ? 0L : this.getMessage().getSize();
    }

    public boolean getDeliveredToConsumer() {
        return (this._deliveryState & 1) != 0;
    }

    public boolean expired() throws AMQException {
        long expiration;
        ServerMessage message = this.getMessage();
        if (message != null && (expiration = message.getExpiration()) != 0L) {
            long now = System.currentTimeMillis();
            return now > expiration;
        }
        return false;
    }

    public boolean isAvailable() {
        return this._state == AVAILABLE_STATE;
    }

    public boolean isAcquired() {
        return this._state.getState() == QueueEntry.State.ACQUIRED;
    }

    public boolean acquire() {
        return this.acquire(NON_SUBSCRIPTION_ACQUIRED_STATE);
    }

    private boolean acquire(QueueEntry.EntryState state) {
        QueueEntry.EntryState currentState;
        boolean acquired = _stateUpdater.compareAndSet(this, AVAILABLE_STATE, state);
        if (!acquired && state != NON_SUBSCRIPTION_ACQUIRED_STATE && (currentState = this._state).getState() == QueueEntry.State.AVAILABLE && (currentState == AVAILABLE_STATE || ((QueueEntry.SubscriptionAcquiredState)state).getSubscription() == ((QueueEntry.SubscriptionAssignedState)currentState).getSubscription() || ((QueueEntry.SubscriptionAssignedState)currentState).getSubscription().isClosed())) {
            acquired = _stateUpdater.compareAndSet(this, currentState, state);
        }
        if (acquired && this._stateChangeListeners != null) {
            this.notifyStateChange(QueueEntry.State.AVAILABLE, QueueEntry.State.ACQUIRED);
        }
        return acquired;
    }

    public boolean acquire(Subscription sub) {
        boolean acquired = this.acquire(sub.getOwningState());
        if (acquired) {
            this._deliveryState |= 1;
        }
        return acquired;
    }

    public boolean acquiredBySubscription() {
        return this._state instanceof QueueEntry.SubscriptionAcquiredState;
    }

    public boolean isAcquiredBy(Subscription subscription) {
        QueueEntry.EntryState state = this._state;
        return state instanceof QueueEntry.SubscriptionAcquiredState && ((QueueEntry.SubscriptionAcquiredState)state).getSubscription() == subscription;
    }

    public void release() {
        QueueEntry.EntryState state = this._state;
        if (state.getState() == QueueEntry.State.ACQUIRED && _stateUpdater.compareAndSet(this, state, AVAILABLE_STATE)) {
            if (state instanceof QueueEntry.SubscriptionAcquiredState) {
                this.getQueue().decrementUnackedMsgCount();
            }
            if (!this.getQueue().isDeleted()) {
                this.getQueue().requeue(this);
                if (this._stateChangeListeners != null) {
                    this.notifyStateChange(QueueEntry.State.ACQUIRED, QueueEntry.State.AVAILABLE);
                }
            } else if (this.acquire()) {
                this.routeToAlternate();
            }
        }
    }

    public boolean releaseButRetain() {
        Subscription sub;
        QueueEntry.EntryState state = this._state;
        boolean stateUpdated = false;
        if (state instanceof QueueEntry.SubscriptionAcquiredState && _stateUpdater.compareAndSet(this, state, (sub = ((QueueEntry.SubscriptionAcquiredState)state).getSubscription()).getAssignedState())) {
            System.err.println("Message released (and retained)" + this.getMessage().getMessageNumber());
            this.getQueue().requeue(this);
            if (this._stateChangeListeners != null) {
                this.notifyStateChange(QueueEntry.State.ACQUIRED, QueueEntry.State.AVAILABLE);
            }
            stateUpdated = true;
        }
        return stateUpdated;
    }

    public boolean immediateAndNotDelivered() {
        return !this.getDeliveredToConsumer() && this.isImmediate();
    }

    private boolean isImmediate() {
        ServerMessage message = this.getMessage();
        return message != null && message.isImmediate();
    }

    public void setRedelivered() {
        this._deliveryState |= 2;
    }

    public AMQMessageHeader getMessageHeader() {
        ServerMessage message = this.getMessage();
        return message == null ? null : message.getMessageHeader();
    }

    public boolean isPersistent() {
        ServerMessage message = this.getMessage();
        return message != null && message.isPersistent();
    }

    public boolean isRedelivered() {
        return (this._deliveryState & 2) != 0;
    }

    public Subscription getDeliveredSubscription() {
        QueueEntry.EntryState state = this._state;
        if (state instanceof QueueEntry.SubscriptionAcquiredState) {
            return ((QueueEntry.SubscriptionAcquiredState)state).getSubscription();
        }
        return null;
    }

    public void reject() {
        this.reject(this.getDeliveredSubscription());
    }

    public void reject(Subscription subscription) {
        if (subscription != null) {
            if (this._rejectedBy == null) {
                this._rejectedBy = new HashSet<Subscription>();
            }
            this._rejectedBy.add(subscription);
        } else {
            _log.warn((Object)("Requesting rejection by null subscriber:" + this));
        }
    }

    public boolean isRejectedBy(Subscription subscription) {
        if (this._rejectedBy != null) {
            return this._rejectedBy.contains(subscription);
        }
        return false;
    }

    public void requeue(Subscription subscription) {
        this.getQueue().requeue(this, subscription);
        if (this._stateChangeListeners != null) {
            this.notifyStateChange(QueueEntry.State.ACQUIRED, QueueEntry.State.AVAILABLE);
        }
    }

    public void dequeue() {
        QueueEntry.EntryState state = this._state;
        if (state.getState() == QueueEntry.State.ACQUIRED && _stateUpdater.compareAndSet(this, state, DEQUEUED_STATE)) {
            Subscription s = null;
            if (state instanceof QueueEntry.SubscriptionAcquiredState) {
                this.getQueue().decrementUnackedMsgCount();
                s = ((QueueEntry.SubscriptionAcquiredState)state).getSubscription();
                s.onDequeue(this);
            }
            this.getQueue().dequeue(this, s);
            if (this._stateChangeListeners != null) {
                this.notifyStateChange(state.getState(), QueueEntry.State.DEQUEUED);
            }
        }
    }

    private void notifyStateChange(QueueEntry.State oldState, QueueEntry.State newState) {
        for (QueueEntry.StateChangeListener l : this._stateChangeListeners) {
            l.stateChanged(this, oldState, newState);
        }
    }

    public void dispose() {
        if (this.delete()) {
            this._message.release();
        }
    }

    public void discard() {
        if (this.getQueue() != null) {
            this.dequeue();
        }
        this.dispose();
    }

    public void routeToAlternate() {
        AMQQueue currentQueue = this.getQueue();
        Exchange alternateExchange = currentQueue.getAlternateExchange();
        if (alternateExchange != null) {
            final ArrayList<? extends BaseQueue> rerouteQueues = alternateExchange.route(new InboundMessageAdapter(this));
            final ServerMessage message = this.getMessage();
            if (rerouteQueues != null && rerouteQueues.size() != 0) {
                AutoCommitTransaction txn = new AutoCommitTransaction(this.getQueue().getVirtualHost().getTransactionLog());
                txn.enqueue(rerouteQueues, (EnqueableMessage)message, new ServerTransaction.Action(){

                    public void postCommit() {
                        try {
                            for (BaseQueue queue : rerouteQueues) {
                                queue.enqueue(message);
                            }
                        }
                        catch (AMQException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public void onRollback() {
                    }
                });
                txn.dequeue(currentQueue, message, new ServerTransaction.Action(){

                    public void postCommit() {
                        QueueEntryImpl.this.discard();
                    }

                    public void onRollback() {
                    }
                });
            }
        }
    }

    public boolean isQueueDeleted() {
        return this.getQueue().isDeleted();
    }

    public void addStateChangeListener(QueueEntry.StateChangeListener listener) {
        Set<QueueEntry.StateChangeListener> listeners = this._stateChangeListeners;
        if (listeners == null) {
            _listenersUpdater.compareAndSet(this, null, new CopyOnWriteArraySet());
            listeners = this._stateChangeListeners;
        }
        listeners.add(listener);
    }

    public boolean removeStateChangeListener(QueueEntry.StateChangeListener listener) {
        Set<QueueEntry.StateChangeListener> listeners = this._stateChangeListeners;
        if (listeners != null) {
            return listeners.remove(listener);
        }
        return false;
    }

    public int compareTo(QueueEntry o) {
        QueueEntryImpl other = (QueueEntryImpl)o;
        return this.getEntryId() > other.getEntryId() ? 1 : (this.getEntryId() < other.getEntryId() ? -1 : 0);
    }

    public QueueEntryImpl getNext() {
        QueueEntryImpl next = this.nextNode();
        while (next != null && next.isDeleted()) {
            QueueEntryImpl newNext = next.nextNode();
            if (newNext != null) {
                SimpleQueueEntryList._nextUpdater.compareAndSet(this, next, newNext);
                next = this.nextNode();
                continue;
            }
            next = null;
        }
        return next;
    }

    QueueEntryImpl nextNode() {
        return this._next;
    }

    public boolean isDeleted() {
        return this._state == DELETED_STATE;
    }

    public boolean delete() {
        QueueEntry.EntryState state = this._state;
        if (state != DELETED_STATE && _stateUpdater.compareAndSet(this, state, DELETED_STATE)) {
            this._queueEntryList.advanceHead();
            return true;
        }
        return false;
    }

    public QueueEntryList getQueueEntryList() {
        return this._queueEntryList;
    }
}

