/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.queue.AMQQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectProperties
extends HashMap<Property, String> {
    private static final long serialVersionUID = -1356019341374170495L;
    public static final String STAR = "*";
    public static final ObjectProperties EMPTY = new ObjectProperties();

    public static List<String> getAllPropertyNames() {
        ArrayList<String> properties = new ArrayList<String>();
        for (Property property : Property.values()) {
            properties.add(StringUtils.remove((String)property.name(), (char)'_').toLowerCase());
        }
        return properties;
    }

    public ObjectProperties() {
    }

    public ObjectProperties(ObjectProperties copy) {
        this.putAll(copy);
    }

    public ObjectProperties(String name) {
        this.setName(name);
    }

    public ObjectProperties(AMQShortString name) {
        this.setName(name);
    }

    public ObjectProperties(AMQQueue queue) {
        this.setName(queue.getName());
        this.put(Property.AUTO_DELETE, queue.isAutoDelete());
        this.put(Property.TEMPORARY, queue.isAutoDelete());
        this.put(Property.DURABLE, queue.isDurable());
        this.put(Property.EXCLUSIVE, queue.isExclusive());
        if (queue.getAlternateExchange() != null) {
            this.put(Property.ALTERNATE, queue.getAlternateExchange().getName());
        }
        if (queue.getOwner() != null) {
            this.put(Property.OWNER, queue.getOwner());
        } else if (queue.getPrincipalHolder() != null) {
            this.put(Property.OWNER, queue.getPrincipalHolder().getPrincipal().getName());
        }
    }

    public ObjectProperties(Exchange exch, AMQQueue queue, AMQShortString routingKey) {
        this(queue);
        this.setName(exch.getName());
        this.put(Property.QUEUE_NAME, queue.getName());
        this.put(Property.ROUTING_KEY, routingKey);
    }

    public ObjectProperties(Exchange exch, AMQShortString routingKey) {
        this(exch.getName(), routingKey.asString());
    }

    public ObjectProperties(String exchangeName, String routingKey, Boolean immediate) {
        this(exchangeName, routingKey);
        this.put(Property.IMMEDIATE, immediate);
    }

    public ObjectProperties(String exchangeName, String routingKey) {
        this.setName(exchangeName);
        this.put(Property.ROUTING_KEY, routingKey);
    }

    public ObjectProperties(Boolean autoDelete, Boolean durable, AMQShortString exchangeName, Boolean internal, Boolean nowait, Boolean passive, AMQShortString exchangeType) {
        this.setName(exchangeName);
        this.put(Property.AUTO_DELETE, autoDelete);
        this.put(Property.TEMPORARY, autoDelete);
        this.put(Property.DURABLE, durable);
        this.put(Property.INTERNAL, internal);
        this.put(Property.NO_WAIT, nowait);
        this.put(Property.PASSIVE, passive);
        this.put(Property.TYPE, exchangeType);
    }

    public ObjectProperties(Boolean autoDelete, Boolean durable, Boolean exclusive, Boolean nowait, Boolean passive, AMQShortString queueName, String owner) {
        this.setName(queueName);
        this.put(Property.AUTO_DELETE, autoDelete);
        this.put(Property.TEMPORARY, autoDelete);
        this.put(Property.DURABLE, durable);
        this.put(Property.EXCLUSIVE, exclusive);
        this.put(Property.NO_WAIT, nowait);
        this.put(Property.PASSIVE, passive);
        this.put(Property.OWNER, owner);
    }

    public ObjectProperties(Boolean exclusive, Boolean noAck, Boolean noLocal, Boolean nowait, AMQQueue queue) {
        this(queue);
        this.put(Property.NO_LOCAL, noLocal);
        this.put(Property.NO_ACK, noAck);
        this.put(Property.EXCLUSIVE, exclusive);
        this.put(Property.NO_WAIT, nowait);
    }

    public List<String> getPropertyNames() {
        ArrayList<String> properties = new ArrayList<String>();
        for (Property property : this.keySet()) {
            properties.add(property.getName());
        }
        return properties;
    }

    public Boolean isSet(Property key) {
        return this.containsKey((Object)key) && Boolean.valueOf((String)this.get((Object)key)) != false;
    }

    public String getName() {
        return (String)this.get((Object)Property.NAME);
    }

    public void setName(String name) {
        this.put(Property.NAME, name);
    }

    public void setName(AMQShortString name) {
        this.put(Property.NAME, name);
    }

    @Override
    public String put(Property key, AMQShortString value) {
        return this.put(key, value == null ? "" : value.asString());
    }

    @Override
    public String put(Property key, String value) {
        return super.put(key, value == null ? "" : value.trim());
    }

    @Override
    public void put(Property key, Boolean value) {
        if (value != null) {
            super.put(key, Boolean.toString(value));
        }
    }

    public boolean matches(ObjectProperties properties) {
        if (properties.keySet().isEmpty()) {
            return true;
        }
        if (!this.keySet().containsAll(properties.keySet())) {
            return false;
        }
        for (Map.Entry entry : properties.entrySet()) {
            Property key = (Property)((Object)entry.getKey());
            String ruleValue = (String)entry.getValue();
            String thisValue = (String)this.get((Object)key);
            if (this.valueMatches(thisValue, ruleValue)) continue;
            return false;
        }
        return true;
    }

    private boolean valueMatches(String thisValue, String ruleValue) {
        return StringUtils.isEmpty((String)ruleValue) || StringUtils.equals((String)thisValue, (String)ruleValue) || ruleValue.equals(STAR) || ruleValue.endsWith(STAR) && thisValue != null && thisValue.length() > ruleValue.length() && thisValue.startsWith(ruleValue.substring(0, ruleValue.length() - 2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        ROUTING_KEY,
        NAME,
        QUEUE_NAME,
        OWNER,
        TYPE,
        ALTERNATE,
        IMMEDIATE,
        INTERNAL,
        NO_WAIT,
        NO_LOCAL,
        NO_ACK,
        PASSIVE,
        DURABLE,
        EXCLUSIVE,
        TEMPORARY,
        AUTO_DELETE,
        COMPONENT,
        PACKAGE,
        CLASS;


        public static Property parse(String text) {
            for (Property property : Property.values()) {
                if (!property.getName().equalsIgnoreCase(text)) continue;
                return property;
            }
            throw new IllegalArgumentException("Not a valid property: " + text);
        }

        public String getName() {
            return StringUtils.remove((String)this.name(), (char)'_').toLowerCase();
        }

        public static List<String> getPropertyNames() {
            ArrayList<String> properties = new ArrayList<String>();
            for (Property property : Property.values()) {
                properties.add(property.getName());
            }
            return properties;
        }
    }
}

