/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.management;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.JMException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.management.common.mbeans.UserManagement;
import org.apache.qpid.management.common.mbeans.annotations.MBeanDescription;
import org.apache.qpid.management.common.mbeans.annotations.MBeanOperation;
import org.apache.qpid.server.management.AMQManagedObject;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.sasl.UsernamePrincipal;

@MBeanDescription(value="User Management Interface")
public class AMQUserManagementMBean
extends AMQManagedObject
implements UserManagement {
    private static final Logger _logger = Logger.getLogger(AMQUserManagementMBean.class);
    private PrincipalDatabase _principalDatabase;
    private Properties _accessRights;
    private File _accessFile;
    private ReentrantLock _accessRightsUpdate = new ReentrantLock();
    static TabularType _userlistDataType;
    static CompositeType _userDataType;

    public AMQUserManagementMBean() throws JMException {
        super(UserManagement.class, "UserManagement");
    }

    public String getObjectInstanceName() {
        return "UserManagement";
    }

    public boolean setPassword(String username, String password) {
        return this.setPassword(username, password.toCharArray());
    }

    public boolean setPassword(String username, char[] password) {
        try {
            return this._principalDatabase.updatePassword(new UsernamePrincipal(username), password);
        }
        catch (AccountNotFoundException e) {
            _logger.warn((Object)("Attempt to set password of non-existant user'" + username + "'"));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRights(String username, boolean read, boolean write, boolean admin) {
        Object oldRights = null;
        oldRights = this._accessRights.get(username);
        if (oldRights == null && this._principalDatabase.getUser(username) == null) {
            return false;
        }
        try {
            this._accessRightsUpdate.lock();
            if (admin) {
                this._accessRights.put(username, "admin");
            } else if (read | write) {
                if (read) {
                    this._accessRights.put(username, "readonly");
                }
                if (write) {
                    this._accessRights.put(username, "readwrite");
                }
            } else {
                this._accessRights.remove(username);
            }
            try {
                this.saveAccessFile();
            }
            catch (IOException e) {
                _logger.warn((Object)("Problem occured saving '" + this._accessFile + "', the access right changes will not be preserved: " + e));
                _logger.warn((Object)("Reverting attempted rights update for user'" + username + "'"));
                if (oldRights != null) {
                    this._accessRights.put(username, oldRights);
                } else {
                    this._accessRights.remove(username);
                }
                boolean bl = false;
                this._accessRightsUpdate.unlock();
                return bl;
            }
        }
        finally {
            this._accessRightsUpdate.unlock();
        }
        return true;
    }

    public boolean createUser(String username, String password, boolean read, boolean write, boolean admin) {
        return this.createUser(username, password.toCharArray(), read, write, admin);
    }

    public boolean createUser(String username, char[] password, boolean read, boolean write, boolean admin) {
        if (this._principalDatabase.createPrincipal(new UsernamePrincipal(username), password)) {
            if (!this.setRights(username, read, write, admin)) {
                try {
                    this._principalDatabase.deletePrincipal(new UsernamePrincipal(username));
                }
                catch (AccountNotFoundException e) {
                    // empty catch block
                }
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteUser(String username) {
        try {
            if (!this._principalDatabase.deletePrincipal(new UsernamePrincipal(username))) return true;
            try {
                this._accessRightsUpdate.lock();
                this._accessRights.remove(username);
                try {
                    this.saveAccessFile();
                    return true;
                }
                catch (IOException e) {
                    _logger.warn((Object)("Problem occured saving '" + this._accessFile + "', the access right changes will not be preserved: " + e));
                    boolean bl = false;
                    this._accessRightsUpdate.unlock();
                    return bl;
                }
            }
            finally {
                this._accessRightsUpdate.unlock();
            }
        }
        catch (AccountNotFoundException e) {
            _logger.warn((Object)("Attempt to delete user (" + username + ") that doesn't exist"));
            return false;
        }
    }

    public boolean reloadData() {
        try {
            this.loadAccessFile();
            this._principalDatabase.reload();
        }
        catch (ConfigurationException e) {
            _logger.warn((Object)("Reload failed due to:" + (Object)((Object)e)));
            return false;
        }
        catch (IOException e) {
            _logger.warn((Object)("Reload failed due to:" + e));
            return false;
        }
        return true;
    }

    @MBeanOperation(name="viewUsers", description="All users with access rights to the system.")
    public TabularData viewUsers() {
        if (_userlistDataType == null) {
            _logger.warn((Object)"TabluarData not setup correctly");
            return null;
        }
        List<Principal> users = this._principalDatabase.getUsers();
        TabularDataSupport userList = new TabularDataSupport(_userlistDataType);
        try {
            for (Principal user : users) {
                String rights = (String)this._accessRights.get(user.getName());
                Boolean read = false;
                Boolean write = false;
                Boolean admin = false;
                if (rights != null) {
                    read = rights.equals("readonly") || rights.equals("readwrite");
                    write = rights.equals("readwrite");
                    admin = rights.equals("admin");
                }
                Object[] itemData = new Object[]{user.getName(), read, write, admin};
                CompositeDataSupport messageData = new CompositeDataSupport(_userDataType, COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), itemData);
                userList.put(messageData);
            }
        }
        catch (OpenDataException e) {
            _logger.warn((Object)("Unable to create user list due to :" + e));
            return null;
        }
        return userList;
    }

    public void setPrincipalDatabase(PrincipalDatabase database) {
        this._principalDatabase = database;
    }

    public void setAccessFile(String accessFile) throws IOException, ConfigurationException {
        if (accessFile != null) {
            this._accessFile = new File(accessFile);
            if (!this._accessFile.exists()) {
                throw new ConfigurationException("'" + this._accessFile + "' does not exist");
            }
            if (!this._accessFile.canRead()) {
                throw new ConfigurationException("Cannot read '" + this._accessFile + "'.");
            }
            if (!this._accessFile.canWrite()) {
                _logger.warn((Object)("Unable to write to access rights file '" + this._accessFile + "', changes will not be preserved."));
            }
            this.loadAccessFile();
        } else {
            _logger.warn((Object)"Access rights file specified is null. Access rights not changed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAccessFile() throws IOException, ConfigurationException {
        if (this._accessFile == null) {
            _logger.error((Object)"No jmx access rights file has been specified.");
            return;
        }
        if (this._accessFile.exists()) {
            try {
                this._accessRightsUpdate.lock();
                Properties accessRights = new Properties();
                FileInputStream inStream = new FileInputStream(this._accessFile);
                try {
                    accessRights.load(inStream);
                }
                finally {
                    inStream.close();
                }
                this.checkAccessRights(accessRights);
                this.setAccessRights(accessRights);
            }
            finally {
                this._accessRightsUpdate.unlock();
            }
        }
        _logger.error((Object)("Specified jmxaccess rights file '" + this._accessFile + "' does not exist."));
    }

    private void checkAccessRights(Properties accessRights) {
        Enumeration<?> values = accessRights.propertyNames();
        while (values.hasMoreElements()) {
            String user = (String)values.nextElement();
            if (this._principalDatabase.getUser(user) != null) continue;
            _logger.warn((Object)("Access rights contains user '" + user + "' but there is no authentication data for that user"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAccessFile() throws IOException {
        try {
            File tmp;
            this._accessRightsUpdate.lock();
            Random r = new Random();
            while ((tmp = new File(this._accessFile.getPath() + r.nextInt() + ".tmp")).exists()) {
            }
            tmp.deleteOnExit();
            FileOutputStream output = new FileOutputStream(tmp);
            this._accessRights.store(output, "Generated by AMQUserManagementMBean Console : Last edited by user:" + this.getCurrentJMXUser());
            output.close();
            File old = new File(this._accessFile.getAbsoluteFile() + ".old");
            if (old.exists()) {
                old.delete();
            }
            if (!this._accessFile.renameTo(old)) {
                _logger.error((Object)"Could not backup the existing management rights file");
                throw new IOException("Could not backup the existing management rights file");
            }
            if (!tmp.renameTo(this._accessFile)) {
                if (!old.renameTo(this._accessFile)) {
                    _logger.error((Object)"Could not rename the new management rights file into place, and unable to restore original file");
                    throw new IOException("Could not rename the new management rights file into place, and unable to restore original file");
                }
                _logger.error((Object)"Could not rename the new management rights file into place");
                throw new IOException("Could not rename the new management rights file into place");
            }
        }
        finally {
            this._accessRightsUpdate.unlock();
        }
    }

    private String getCurrentJMXUser() {
        AccessControlContext acc = AccessController.getContext();
        Subject subject = Subject.getSubject(acc);
        if (subject == null) {
            return "Unknown user, authentication Subject was null";
        }
        Set<JMXPrincipal> principals = subject.getPrincipals(JMXPrincipal.class);
        if (principals == null || principals.isEmpty()) {
            return "Unknown user principals were null";
        }
        Principal principal = principals.iterator().next();
        return principal.getName();
    }

    private void setAccessRights(Properties accessRights) {
        _logger.debug((Object)("Setting Access Rights:" + accessRights));
        this._accessRights = accessRights;
    }

    static {
        OpenType[] userItemTypes = new OpenType[]{SimpleType.STRING, SimpleType.BOOLEAN, SimpleType.BOOLEAN, SimpleType.BOOLEAN};
        try {
            _userDataType = new CompositeType("User", "User Data", COMPOSITE_ITEM_NAMES.toArray(new String[COMPOSITE_ITEM_NAMES.size()]), COMPOSITE_ITEM_DESCRIPTIONS.toArray(new String[COMPOSITE_ITEM_DESCRIPTIONS.size()]), userItemTypes);
            _userlistDataType = new TabularType("Users", "List of users", _userDataType, TABULAR_UNIQUE_INDEX.toArray(new String[TABULAR_UNIQUE_INDEX.size()]));
        }
        catch (OpenDataException e) {
            _logger.error((Object)"Tabular data setup for viewing users incorrect.");
            _userlistDataType = null;
        }
    }
}

