/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.crammd5;

import java.util.Enumeration;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.qpid.server.security.auth.sasl.crammd5.CRAMMD5HexServerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRAMMD5HexSaslServer
implements SaslServer {
    public static final String MECHANISM = "CRAM-MD5-HEX";
    private SaslServer _realServer;

    public CRAMMD5HexSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        Enumeration<SaslServerFactory> factories = Sasl.getSaslServerFactories();
        while (factories.hasMoreElements()) {
            String[] mechs;
            SaslServerFactory factory = factories.nextElement();
            if (factory instanceof CRAMMD5HexServerFactory) continue;
            for (String mech : mechs = factory.getMechanismNames(props)) {
                if (!mech.equals("CRAM-MD5")) continue;
                this._realServer = factory.createSaslServer("CRAM-MD5", protocol, serverName, props, cbh);
                return;
            }
        }
        throw new RuntimeException("No default SaslServer found for mechanism:CRAM-MD5");
    }

    @Override
    public String getMechanismName() {
        return MECHANISM;
    }

    @Override
    public byte[] evaluateResponse(byte[] response) throws SaslException {
        return this._realServer.evaluateResponse(response);
    }

    @Override
    public boolean isComplete() {
        return this._realServer.isComplete();
    }

    @Override
    public String getAuthorizationID() {
        return this._realServer.getAuthorizationID();
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return this._realServer.unwrap(incoming, offset, len);
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return this._realServer.wrap(outgoing, offset, len);
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        return this._realServer.getNegotiatedProperty(propName);
    }

    @Override
    public void dispose() throws SaslException {
        this._realServer.dispose();
    }
}

