/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl.plain;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.security.auth.sasl.plain.PlainPasswordCallback;

public class PlainSaslServer
implements SaslServer {
    public static final String MECHANISM = "PLAIN";
    private CallbackHandler _cbh;
    private String _authorizationId;
    private boolean _complete = false;

    public PlainSaslServer(CallbackHandler cbh) {
        this._cbh = cbh;
    }

    public String getMechanismName() {
        return MECHANISM;
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        try {
            int authzidNullPosition = this.findNullPosition(response, 0);
            if (authzidNullPosition < 0) {
                throw new SaslException("Invalid PLAIN encoding, authzid null terminator not found");
            }
            int authcidNullPosition = this.findNullPosition(response, authzidNullPosition + 1);
            if (authcidNullPosition < 0) {
                throw new SaslException("Invalid PLAIN encoding, authcid null terminator not found");
            }
            String authzid = new String(response, authzidNullPosition + 1, authcidNullPosition - authzidNullPosition - 1, "utf8");
            int passwordLen = response.length - authcidNullPosition - 1;
            String pwd = new String(response, authcidNullPosition + 1, passwordLen, "utf8");
            NameCallback nameCb = new NameCallback("prompt", authzid);
            PlainPasswordCallback passwordCb = new PlainPasswordCallback("prompt", false, pwd);
            AuthorizeCallback authzCb = new AuthorizeCallback(authzid, authzid);
            Callback[] callbacks = new Callback[]{nameCb, passwordCb, authzCb};
            this._cbh.handle(callbacks);
            if (passwordCb.isAuthenticated()) {
                this._complete = true;
            }
            if (authzCb.isAuthorized() && this._complete) {
                this._authorizationId = authzCb.getAuthenticationID();
                return null;
            }
            throw new SaslException("Authentication failed");
        }
        catch (IOException e) {
            throw new SaslException("Error processing data: " + e, e);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("Unable to obtain data from callback handler: " + e, e);
        }
    }

    private int findNullPosition(byte[] response, int startPosition) {
        for (int position = startPosition; position < response.length; ++position) {
            if (response[position] != 0) continue;
            return position;
        }
        return -1;
    }

    public boolean isComplete() {
        return this._complete;
    }

    public String getAuthorizationID() {
        return this._authorizationId;
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        throw new SaslException("Unsupported operation");
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        throw new SaslException("Unsupported operation");
    }

    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    public void dispose() throws SaslException {
        this._cbh = null;
    }
}

