/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.common.Closeable;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualHostRegistry
implements Closeable {
    private final Map<String, VirtualHost> _registry = new ConcurrentHashMap<String, VirtualHost>();
    private String _defaultVirtualHostName;
    private ApplicationRegistry _applicationRegistry;

    public VirtualHostRegistry(ApplicationRegistry applicationRegistry) {
        this._applicationRegistry = applicationRegistry;
    }

    public synchronized void registerVirtualHost(VirtualHost host) throws Exception {
        if (this._registry.containsKey(host.getName())) {
            throw new Exception("Virtual Host with name " + host.getName() + " already registered.");
        }
        this._registry.put(host.getName(), host);
    }

    public synchronized void unregisterVirtualHost(VirtualHost host) {
        this._registry.remove(host.getName());
    }

    public VirtualHost getVirtualHost(String name) {
        if (name == null || name.trim().length() == 0 || "/".equals(name.trim())) {
            name = this.getDefaultVirtualHostName();
        }
        return this._registry.get(name);
    }

    public VirtualHost getDefaultVirtualHost() {
        return this.getVirtualHost(this.getDefaultVirtualHostName());
    }

    private String getDefaultVirtualHostName() {
        return this._defaultVirtualHostName;
    }

    public void setDefaultVirtualHostName(String defaultVirtualHostName) {
        this._defaultVirtualHostName = defaultVirtualHostName;
    }

    public Collection<VirtualHost> getVirtualHosts() {
        return new ArrayList<VirtualHost>(this._registry.values());
    }

    public ApplicationRegistry getApplicationRegistry() {
        return this._applicationRegistry;
    }

    public ConfigStore getConfigStore() {
        return this._applicationRegistry.getConfigStore();
    }

    public void close() {
        for (VirtualHost virtualHost : this.getVirtualHosts()) {
            virtualHost.close();
        }
    }
}

