/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.tools.messagestore;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.qpid.configuration.Configuration;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.ConfigurationFileApplicationRegistry;
import org.apache.qpid.server.store.MemoryMessageStore;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.tools.messagestore.commands.Clear;
import org.apache.qpid.tools.messagestore.commands.Command;
import org.apache.qpid.tools.messagestore.commands.Copy;
import org.apache.qpid.tools.messagestore.commands.Dump;
import org.apache.qpid.tools.messagestore.commands.Help;
import org.apache.qpid.tools.messagestore.commands.List;
import org.apache.qpid.tools.messagestore.commands.Load;
import org.apache.qpid.tools.messagestore.commands.Move;
import org.apache.qpid.tools.messagestore.commands.Purge;
import org.apache.qpid.tools.messagestore.commands.Quit;
import org.apache.qpid.tools.messagestore.commands.Select;
import org.apache.qpid.tools.messagestore.commands.Show;
import org.apache.qpid.tools.utils.CommandParser;
import org.apache.qpid.tools.utils.Console;
import org.apache.qpid.tools.utils.SimpleCommandParser;
import org.apache.qpid.tools.utils.SimpleConsole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageStoreTool {
    private static final String BOILER_PLATE = "MessageStoreTool - for examining Persistent Qpid Broker MessageStore instances";
    protected Console _console;
    protected boolean _batchMode;
    private State _state = new State();
    private HashMap<String, Command> _commands = new HashMap();
    private static Logger _devlog = LoggerFactory.getLogger(MessageStoreTool.class);
    private Configuration _config;
    private boolean _running = true;
    private boolean _initialised = false;

    public static void main(String[] args) throws Configuration.InitException {
        MessageStoreTool tool = new MessageStoreTool(args);
        tool.start();
    }

    public MessageStoreTool(String[] args) throws Configuration.InitException {
        this(args, System.in, System.out);
    }

    public MessageStoreTool(String[] args, InputStream in, OutputStream out) throws Configuration.InitException {
        BufferedReader consoleReader = new BufferedReader(new InputStreamReader(in));
        BufferedWriter consoleWriter = new BufferedWriter(new OutputStreamWriter(out));
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHook(this)));
        this._batchMode = false;
        this._console = new SimpleConsole(consoleWriter, consoleReader);
        this._config = new Configuration();
        this.setOptions();
        this._config.processCommandline(args);
    }

    private void setOptions() {
        Option help = new Option("h", "help", false, "print this message");
        Option version = new Option("v", "version", false, "print the version information and exit");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given configuration file By default looks for a file named etc/config.xml in QPID_HOME");
        OptionBuilder.withLongOpt((String)"config");
        Option configFile = OptionBuilder.create((String)"c");
        this._config.setOption(help);
        this._config.setOption(version);
        this._config.setOption(configFile);
    }

    public State getState() {
        return this._state;
    }

    public Map<String, Command> getCommands() {
        return this._commands;
    }

    public void setConfigurationFile(String configfile) throws Configuration.InitException {
        this._config.loadConfig(new File(configfile));
        this.setup();
    }

    public Console getConsole() {
        return this._console;
    }

    public void setConsole(Console console) {
        this._console = console;
    }

    public void quit() {
        this._running = false;
        if (this._initialised) {
            ApplicationRegistry.remove(1);
        }
        this._console.println("...exiting");
        this._console.close();
    }

    public void setBatchMode(boolean batchmode) {
        this._batchMode = batchmode;
    }

    protected void start() {
        this.setup();
        if (!this._initialised) {
            System.exit(1);
        }
        this._console.println("");
        this._console.println(BOILER_PLATE);
        this.runCLI();
    }

    private void setup() {
        this.loadDefaultVirtualHosts();
        this.loadCommands();
        this._state.clearAll();
    }

    private void loadCommands() {
        this._commands.clear();
        this._commands.put("close", new Clear(this));
        this._commands.put("copy", new Copy(this));
        this._commands.put("dump", new Dump(this));
        this._commands.put("help", new Help(this));
        this._commands.put("list", new List(this));
        this._commands.put("load", new Load(this));
        this._commands.put("move", new Move(this));
        this._commands.put("purge", new Purge(this));
        this._commands.put("quit", new Quit(this));
        this._commands.put("select", new Select(this));
        this._commands.put("show", new Show(this));
    }

    private void loadDefaultVirtualHosts() {
        File configFile = this._config.getConfigFile();
        this.loadVirtualHosts(configFile);
    }

    private void loadVirtualHosts(File configFile) {
        if (!configFile.exists()) {
            _devlog.error("Config file not found:" + configFile.getAbsolutePath());
            return;
        }
        _devlog.debug("using config file :" + configFile.getAbsolutePath());
        try {
            ConfigurationFileApplicationRegistry registry = new ConfigurationFileApplicationRegistry(configFile);
            ApplicationRegistry.remove(1);
            ApplicationRegistry.initialise(registry);
            this.checkMessageStores();
            this._initialised = true;
        }
        catch (ConfigurationException e) {
            this._console.println("Unable to load configuration due to configuration error: " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            this._console.println("Unable to load configuration due to: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void checkMessageStores() {
        Collection<VirtualHost> vhosts = ApplicationRegistry.getInstance().getVirtualHostRegistry().getVirtualHosts();
        boolean warning = false;
        for (VirtualHost vhost : vhosts) {
            if (!(vhost.getMessageStore() instanceof MemoryMessageStore)) continue;
            this._console.println("WARNING: Virtualhost '" + vhost.getName() + "' is using a MemoryMessageStore. " + "Changes will not persist.");
            warning = true;
        }
        if (warning) {
            this._console.println("");
            this._console.println("Please ensure you are using the correct config file currently using '" + this._config.getConfigFile().getAbsolutePath() + "'");
            this._console.println("New config file can be specifed by 'load <config file>' or -c on the commandline.");
            this._console.println("");
        }
    }

    private void runCLI() {
        while (this._running) {
            if (!this._batchMode) {
                this.printPrompt();
            }
            String[] args = this._console.readCommand();
            while (args != null) {
                this.exec(args);
                if (!this._running) continue;
                if (!this._batchMode) {
                    this.printPrompt();
                }
                args = this._console.readCommand();
            }
        }
    }

    private void printPrompt() {
        this._console.print(this.prompt());
    }

    protected void runScripts(String script) {
        boolean oldBatch = this._batchMode;
        CommandParser oldParser = this._console.getCommandParser();
        this.setBatchMode(true);
        try {
            _devlog.debug("Running script '" + script + "'");
            this._console.setCommandParser(new SimpleCommandParser(new BufferedReader(new FileReader(script))));
            this.start();
        }
        catch (FileNotFoundException e) {
            _devlog.error("Script not found: '" + script + "' due to:" + e.getMessage());
        }
        this._console.setCommandParser(oldParser);
        this.setBatchMode(oldBatch);
    }

    public String prompt() {
        String state = this._state.toString();
        if (state != null && state.length() != 0) {
            return state + ":bdb$ ";
        }
        return "bdb$ ";
    }

    protected void exec(String[] args) {
        if (args.length == 0 || args[0].startsWith("#")) {
            return;
        }
        String command = args[0];
        Command cmd = this._commands.get(command);
        if (cmd == null) {
            this._console.println("Command not understood: " + command);
        } else {
            cmd.execute(args);
        }
    }

    protected static void help() {
        System.out.println(BOILER_PLATE);
        System.out.println("Usage: java " + MessageStoreTool.class + " [Options]");
        System.out.println("       [-c <broker config file>] : Defaults to \"$QPID_HOME/etc/config.xml\"");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class State {
        private VirtualHost _vhost = null;
        private AMQQueue _queue = null;
        private Exchange _exchange = null;
        private java.util.List<Long> _msgids = null;

        public void setQueue(AMQQueue queue) {
            this._queue = queue;
        }

        public AMQQueue getQueue() {
            return this._queue;
        }

        public void setVhost(VirtualHost vhost) {
            this._vhost = vhost;
        }

        public VirtualHost getVhost() {
            return this._vhost;
        }

        public Exchange getExchange() {
            return this._exchange;
        }

        public void setExchange(Exchange exchange) {
            this._exchange = exchange;
        }

        public String toString() {
            StringBuilder status = new StringBuilder();
            if (this._vhost != null) {
                status.append(this._vhost.getName());
                if (this._exchange != null) {
                    status.append("[");
                    status.append((CharSequence)this._exchange.getNameShortString());
                    status.append("]");
                    if (this._queue != null) {
                        status.append("->'");
                        status.append((CharSequence)this._queue.getNameShortString());
                        status.append("'");
                        if (this._msgids != null) {
                            status.append(this.printMessages());
                        }
                    }
                }
            }
            return status.toString();
        }

        public String printMessages() {
            StringBuilder sb = new StringBuilder();
            Long previous = null;
            Long start = null;
            for (Long id : this._msgids) {
                if (previous != null) {
                    if (id == previous + 1L) {
                        if (start == null) {
                            start = previous;
                        }
                    } else if (start != null) {
                        sb.append(",");
                        sb.append(start);
                        sb.append("-");
                        sb.append(id);
                        start = null;
                    } else {
                        sb.append(",");
                        sb.append(previous);
                    }
                }
                previous = id;
            }
            if (start != null) {
                sb.append(",");
                sb.append(start);
                sb.append("-");
                sb.append(this._msgids.get(this._msgids.size() - 1));
            } else {
                sb.append(",");
                sb.append(previous);
            }
            sb.replace(0, 1, "(");
            sb.append(")");
            return sb.toString();
        }

        public void clearAll() {
            this._vhost = null;
            this.clearExchange();
        }

        public void clearExchange() {
            this._exchange = null;
            this.clearQueue();
        }

        public void clearQueue() {
            this._queue = null;
            this.clearMessages();
        }

        public void clearMessages() {
            this._msgids = null;
        }

        public void setMessages(String msgString) {
            StringTokenizer tok = new StringTokenizer(msgString, ",");
            if (tok.hasMoreTokens()) {
                this._msgids = new LinkedList<Long>();
            }
            while (tok.hasMoreTokens()) {
                String next = tok.nextToken();
                if (next.contains("-")) {
                    Long start = Long.parseLong(next.substring(0, next.indexOf("-")));
                    Long end = Long.parseLong(next.substring(next.indexOf("-") + 1));
                    if (end < start) continue;
                    for (long l = start.longValue(); l <= end; ++l) {
                        this._msgids.add(l);
                    }
                    continue;
                }
                this._msgids.add(Long.parseLong(next));
            }
        }

        public void setMessages(java.util.List<Long> msgids) {
            this._msgids = msgids;
        }

        public java.util.List<Long> getMessages() {
            return this._msgids;
        }
    }

    static class ShutdownHook
    implements Runnable {
        MessageStoreTool _tool;

        ShutdownHook(MessageStoreTool messageStoreTool) {
            this._tool = messageStoreTool;
        }

        public void run() {
            this._tool.quit();
        }
    }
}

