/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.tools.messagestore.commands;

import org.apache.qpid.configuration.Configuration;
import org.apache.qpid.tools.messagestore.MessageStoreTool;
import org.apache.qpid.tools.messagestore.commands.AbstractCommand;

public class Load
extends AbstractCommand {
    public Load(MessageStoreTool tool) {
        super(tool);
    }

    public String help() {
        return "Loads specified broker configuration file.";
    }

    public String usage() {
        return "load <configuration file>";
    }

    public String getCommand() {
        return "load";
    }

    public void execute(String ... args) {
        assert (args.length > 0);
        assert (args[0].equals(this.getCommand()));
        if (args.length > 2) {
            this._console.print("load " + args[1] + ": additional options not understood:");
            for (int i = 2; i < args.length; ++i) {
                this._console.print(args[i] + " ");
            }
            this._console.println("");
        } else if (args.length < 2) {
            this._console.println("Enter Configuration file.");
            String input = this._console.readln();
            if (input != null) {
                this.doLoad(input);
            } else {
                this._console.println("Did not recognise config file.");
            }
        } else {
            this.doLoad(args[1]);
        }
    }

    private void doLoad(String configfile) {
        this._console.println("Loading Configuration:" + configfile);
        try {
            this._tool.setConfigurationFile(configfile);
        }
        catch (Configuration.InitException e) {
            this._console.println("Unable to open config file due to: '" + e.getMessage() + "'");
        }
    }
}

