/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.tools.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.qpid.tools.utils.CommandParser;

public class SimpleCommandParser
implements CommandParser {
    private static final String COMMAND_SEPERATOR = ";";
    protected BufferedReader _reader;
    private StringBuilder _nextCommand = null;

    public SimpleCommandParser(BufferedReader reader) {
        this._reader = reader;
    }

    public boolean more() {
        return this._nextCommand != null;
    }

    public boolean isBackground() {
        return false;
    }

    public String[] parse() throws IOException {
        String[] commands = null;
        String input = null;
        if (this._nextCommand == null) {
            input = this._reader.readLine();
        } else {
            input = this._nextCommand.toString();
            this._nextCommand = null;
        }
        if (input == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(input, " ");
        int tokenCount = tok.countTokens();
        int index = 0;
        if (tokenCount > 0) {
            commands = new String[tokenCount];
            boolean commandComplete = false;
            while (tok.hasMoreTokens()) {
                String next = tok.nextToken();
                if (next.equals(COMMAND_SEPERATOR)) {
                    commandComplete = true;
                    this._nextCommand = new StringBuilder();
                    continue;
                }
                if (commandComplete) {
                    this._nextCommand.append(next);
                    this._nextCommand.append(" ");
                    continue;
                }
                commands[index] = next;
                ++index;
            }
        }
        if (index != tokenCount) {
            String[] shortCommands = new String[index];
            System.arraycopy(commands, 0, shortCommands, 0, index);
            return shortCommands;
        }
        return commands;
    }
}

