/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.QpidLog4JConfigurator;
import org.apache.qpid.protocol.ProtocolEngineFactory;
import org.apache.qpid.server.BrokerOptions;
import org.apache.qpid.server.ProtocolExclusion;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.configuration.ServerNetworkTransportConfiguration;
import org.apache.qpid.server.configuration.management.ConfigurationManagementMBean;
import org.apache.qpid.server.information.management.ServerInformationMBean;
import org.apache.qpid.server.logging.SystemOutMessageLogger;
import org.apache.qpid.server.logging.actors.BrokerActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.GenericActor;
import org.apache.qpid.server.logging.management.LoggingManagementMBean;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.protocol.AmqpProtocolVersion;
import org.apache.qpid.server.protocol.MultiVersionProtocolEngineFactory;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.ConfigurationFileApplicationRegistry;
import org.apache.qpid.server.transport.QpidAcceptor;
import org.apache.qpid.ssl.SSLContextFactory;
import org.apache.qpid.transport.NetworkTransportConfiguration;
import org.apache.qpid.transport.network.IncomingNetworkTransport;
import org.apache.qpid.transport.network.NetworkTransport;
import org.apache.qpid.transport.network.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Broker {
    private static final int IPV4_ADDRESS_LENGTH = 4;
    private static final char IPV4_LITERAL_SEPARATOR = '.';

    public void shutdown() {
        ApplicationRegistry.remove();
    }

    public void startup() throws Exception {
        this.startup(new BrokerOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(BrokerOptions options) throws Exception {
        try {
            CurrentActor.set(new BrokerActor(new SystemOutMessageLogger()));
            this.startupImpl(options);
        }
        finally {
            CurrentActor.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupImpl(BrokerOptions options) throws Exception {
        String qpidHome = options.getQpidHome();
        File configFile = this.getConfigFile(options.getConfigFile(), "etc/config.xml", qpidHome, true);
        CurrentActor.get().message(BrokerMessages.CONFIG(configFile.getAbsolutePath()));
        File logConfigFile = this.getConfigFile(options.getLogConfigFile(), "etc/log4j.xml", qpidHome, false);
        this.configureLogging(logConfigFile, options.getLogWatchFrequency());
        ConfigurationFileApplicationRegistry config = new ConfigurationFileApplicationRegistry(configFile, options.getBundleContext());
        ServerConfiguration serverConfig = config.getConfiguration();
        this.updateManagementPorts(serverConfig, options.getJmxPortRegistryServer(), options.getJmxPortConnectorServer());
        ApplicationRegistry.initialise(config);
        BrokerMessages.reload();
        CurrentActor.set(new BrokerActor(config.getCompositeStartupMessageLogger()));
        CurrentActor.setDefault(new BrokerActor(config.getRootMessageLogger()));
        GenericActor.setDefaultMessageLogger(config.getRootMessageLogger());
        try {
            String bindAddr;
            HashSet<Integer> exclude_0_8;
            HashSet<Integer> exclude_0_9;
            HashSet<Integer> exclude_0_9_1;
            HashSet<Integer> exclude_0_10;
            HashSet<Integer> sslPorts;
            this.configureLoggingManagementMBean(logConfigFile, options.getLogWatchFrequency());
            ConfigurationManagementMBean configMBean = new ConfigurationManagementMBean();
            configMBean.register();
            ServerInformationMBean sysInfoMBean = new ServerInformationMBean(config);
            sysInfoMBean.register();
            HashSet<Integer> ports = new HashSet<Integer>(options.getPorts());
            if (ports.isEmpty()) {
                Broker.parsePortList(ports, serverConfig.getPorts());
            }
            if ((sslPorts = new HashSet<Integer>(options.getSSLPorts())).isEmpty()) {
                Broker.parsePortList(sslPorts, serverConfig.getSSLPorts());
            }
            if ((exclude_0_10 = new HashSet<Integer>(options.getExcludedPorts(ProtocolExclusion.v0_10))).isEmpty()) {
                Broker.parsePortList(exclude_0_10, serverConfig.getPortExclude010());
            }
            if ((exclude_0_9_1 = new HashSet<Integer>(options.getExcludedPorts(ProtocolExclusion.v0_9_1))).isEmpty()) {
                Broker.parsePortList(exclude_0_9_1, serverConfig.getPortExclude091());
            }
            if ((exclude_0_9 = new HashSet<Integer>(options.getExcludedPorts(ProtocolExclusion.v0_9))).isEmpty()) {
                Broker.parsePortList(exclude_0_9, serverConfig.getPortExclude09());
            }
            if ((exclude_0_8 = new HashSet<Integer>(options.getExcludedPorts(ProtocolExclusion.v0_8))).isEmpty()) {
                Broker.parsePortList(exclude_0_8, serverConfig.getPortExclude08());
            }
            if ((bindAddr = options.getBind()) == null) {
                bindAddr = serverConfig.getBind();
            }
            InetAddress bindAddress = null;
            bindAddress = bindAddr.equals("*") ? new InetSocketAddress(0).getAddress() : InetAddress.getByAddress(this.parseIP(bindAddr));
            String hostName = bindAddress.getCanonicalHostName();
            if (!serverConfig.getSSLOnly()) {
                Iterator i$ = ports.iterator();
                while (i$.hasNext()) {
                    int port = (Integer)i$.next();
                    Set<AmqpProtocolVersion> supported = Broker.getSupportedVersions(port, exclude_0_10, exclude_0_9_1, exclude_0_9, exclude_0_8);
                    ServerNetworkTransportConfiguration settings = new ServerNetworkTransportConfiguration(serverConfig, port, bindAddress.getHostName(), "tcp");
                    IncomingNetworkTransport transport = Transport.getIncomingTransportInstance();
                    MultiVersionProtocolEngineFactory protocolEngineFactory = new MultiVersionProtocolEngineFactory(hostName, supported);
                    transport.accept((NetworkTransportConfiguration)settings, (ProtocolEngineFactory)protocolEngineFactory, null);
                    ApplicationRegistry.getInstance().addAcceptor(new InetSocketAddress(bindAddress, port), new QpidAcceptor((NetworkTransport)transport, "TCP"));
                    CurrentActor.get().message(BrokerMessages.LISTENING("TCP", port));
                }
            }
            if (serverConfig.getEnableSSL()) {
                String keystorePath = serverConfig.getConnectorKeyStorePath();
                String keystorePassword = serverConfig.getConnectorKeyStorePassword();
                String certType = serverConfig.getConnectorCertType();
                SSLContext sslContext = SSLContextFactory.buildServerContext((String)keystorePath, (String)keystorePassword, (String)certType);
                Iterator i$ = sslPorts.iterator();
                while (i$.hasNext()) {
                    int sslPort = (Integer)i$.next();
                    Set<AmqpProtocolVersion> supported = Broker.getSupportedVersions(sslPort, exclude_0_10, exclude_0_9_1, exclude_0_9, exclude_0_8);
                    ServerNetworkTransportConfiguration settings = new ServerNetworkTransportConfiguration(serverConfig, sslPort, bindAddress.getHostName(), "tcp");
                    IncomingNetworkTransport transport = Transport.getIncomingTransportInstance();
                    MultiVersionProtocolEngineFactory protocolEngineFactory = new MultiVersionProtocolEngineFactory(hostName, supported);
                    transport.accept((NetworkTransportConfiguration)settings, (ProtocolEngineFactory)protocolEngineFactory, sslContext);
                    ApplicationRegistry.getInstance().addAcceptor(new InetSocketAddress(bindAddress, sslPort), new QpidAcceptor((NetworkTransport)transport, "TCP"));
                    CurrentActor.get().message(BrokerMessages.LISTENING("TCP/SSL", sslPort));
                }
            }
            CurrentActor.get().message(BrokerMessages.READY());
        }
        finally {
            CurrentActor.remove();
        }
    }

    private static Set<AmqpProtocolVersion> getSupportedVersions(int port, Set<Integer> exclude_0_10, Set<Integer> exclude_0_9_1, Set<Integer> exclude_0_9, Set<Integer> exclude_0_8) {
        EnumSet<AmqpProtocolVersion> supported = EnumSet.allOf(AmqpProtocolVersion.class);
        if (exclude_0_10.contains(port)) {
            supported.remove((Object)AmqpProtocolVersion.v0_10);
        }
        if (exclude_0_9_1.contains(port)) {
            supported.remove((Object)AmqpProtocolVersion.v0_9_1);
        }
        if (exclude_0_9.contains(port)) {
            supported.remove((Object)AmqpProtocolVersion.v0_9);
        }
        if (exclude_0_8.contains(port)) {
            supported.remove((Object)AmqpProtocolVersion.v0_8);
        }
        return supported;
    }

    private File getConfigFile(String fileName, String defaultFileName, String qpidHome, boolean throwOnFileNotFound) throws InitException {
        File configFile = null;
        configFile = fileName != null ? new File(fileName) : new File(qpidHome, defaultFileName);
        if (!configFile.exists() && throwOnFileNotFound) {
            String error = "File " + fileName + " could not be found. Check the file exists and is readable.";
            if (qpidHome == null) {
                error = error + "\nNote: " + "QPID_HOME" + " is not set.";
            }
            throw new InitException(error, null);
        }
        return configFile;
    }

    public static void parsePortList(Set<Integer> output, List<?> ports) throws InitException {
        if (ports != null) {
            for (Object o : ports) {
                try {
                    output.add(Integer.parseInt(String.valueOf(o)));
                }
                catch (NumberFormatException e) {
                    throw new InitException("Invalid port: " + o, e);
                }
            }
        }
    }

    private void updateManagementPorts(ServerConfiguration configuration, Integer registryServerPort, Integer connectorServerPort) {
        if (registryServerPort != null) {
            try {
                configuration.setJMXPortRegistryServer(registryServerPort);
            }
            catch (NumberFormatException e) {
                throw new InitException("Invalid management (registry server) port: " + registryServerPort, null);
            }
        }
        if (connectorServerPort != null) {
            try {
                configuration.setJMXPortConnectorServer(connectorServerPort);
            }
            catch (NumberFormatException e) {
                throw new InitException("Invalid management (connector server) port: " + connectorServerPort, null);
            }
        }
    }

    private byte[] parseIP(String address) throws Exception {
        char[] literalBuffer = address.toCharArray();
        int byteCount = 0;
        int currByte = 0;
        byte[] ip = new byte[4];
        for (int i = 0; i < literalBuffer.length; ++i) {
            char currChar = literalBuffer[i];
            if (currChar >= '0' && currChar <= '9') {
                currByte = currByte * 10 + (Character.digit(currChar, 10) & 0xFF);
            }
            if (currChar != '.' && i + 1 != literalBuffer.length) continue;
            ip[byteCount++] = (byte)currByte;
            currByte = 0;
        }
        if (byteCount != 4) {
            throw new Exception("Invalid IP address: " + address);
        }
        return ip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLogging(File logConfigFile, long logWatchTime) throws InitException, IOException {
        if (logConfigFile.exists() && logConfigFile.canRead()) {
            CurrentActor.get().message(BrokerMessages.LOG_CONFIG(logConfigFile.getAbsolutePath()));
            if (logWatchTime > 0L) {
                System.out.println("log file " + logConfigFile.getAbsolutePath() + " will be checked for changes every " + logWatchTime + " seconds");
                try {
                    QpidLog4JConfigurator.configureAndWatch(logConfigFile.getPath(), logWatchTime * 1000L);
                }
                catch (Exception e) {
                    throw new InitException(e.getMessage(), e);
                }
            } else {
                try {
                    QpidLog4JConfigurator.configure(logConfigFile.getPath());
                }
                catch (Exception e) {
                    throw new InitException(e.getMessage(), e);
                }
            }
        } else {
            System.err.println("Logging configuration error: unable to read file " + logConfigFile.getAbsolutePath());
            System.err.println("Using the fallback internal log4j.properties configuration");
            InputStream propsFile = this.getClass().getResourceAsStream("/log4j.properties");
            if (propsFile == null) {
                throw new IOException("Unable to load the fallback internal log4j.properties configuration file");
            }
            try {
                Properties fallbackProps = new Properties();
                fallbackProps.load(propsFile);
                PropertyConfigurator.configure((Properties)fallbackProps);
            }
            finally {
                propsFile.close();
            }
        }
    }

    private void configureLoggingManagementMBean(File logConfigFile, int logWatchTime) throws Exception {
        LoggingManagementMBean blm = new LoggingManagementMBean(logConfigFile.getPath(), logWatchTime);
        blm.register();
    }

    protected static class InitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        InitException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

