/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.ProtocolExclusion;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrokerOptions {
    private static final long serialVersionUID = 8051825964945442234L;
    public static final String DEFAULT_CONFIG_FILE = "etc/config.xml";
    public static final String DEFAULT_LOG_CONFIG_FILE = "etc/log4j.xml";
    public static final String QPID_HOME = "QPID_HOME";
    private final Set<Integer> _ports = new HashSet<Integer>();
    private final Set<Integer> _sslPorts = new HashSet<Integer>();
    private final Map<ProtocolExclusion, Set<Integer>> _exclusionMap = new HashMap<ProtocolExclusion, Set<Integer>>();
    private String _configFile;
    private String _logConfigFile;
    private String _bind;
    private Integer _jmxPortRegistryServer;
    private Integer _jmxPortConnectorServer;
    private BundleContext _bundleContext;
    private Integer _logWatchFrequency = 0;

    public void addPort(int port) {
        this._ports.add(port);
    }

    public void addSSLPort(int sslPort) {
        this._sslPorts.add(sslPort);
    }

    public Set<Integer> getPorts() {
        return Collections.unmodifiableSet(this._ports);
    }

    public Set<Integer> getSSLPorts() {
        return Collections.unmodifiableSet(this._sslPorts);
    }

    public String getConfigFile() {
        return this._configFile;
    }

    public void setConfigFile(String configFile) {
        this._configFile = configFile;
    }

    public String getLogConfigFile() {
        return this._logConfigFile;
    }

    public void setLogConfigFile(String logConfigFile) {
        this._logConfigFile = logConfigFile;
    }

    public Integer getJmxPortRegistryServer() {
        return this._jmxPortRegistryServer;
    }

    public void setJmxPortRegistryServer(int jmxPortRegistryServer) {
        this._jmxPortRegistryServer = jmxPortRegistryServer;
    }

    public Integer getJmxPortConnectorServer() {
        return this._jmxPortConnectorServer;
    }

    public void setJmxPortConnectorServer(int jmxPortConnectorServer) {
        this._jmxPortConnectorServer = jmxPortConnectorServer;
    }

    public String getQpidHome() {
        return System.getProperty(QPID_HOME);
    }

    public Set<Integer> getExcludedPorts(ProtocolExclusion excludeProtocol) {
        Set<Integer> excludedPorts = this._exclusionMap.get((Object)excludeProtocol);
        return excludedPorts == null ? Collections.emptySet() : excludedPorts;
    }

    public void addExcludedPort(ProtocolExclusion excludeProtocol, int port) {
        if (!this._exclusionMap.containsKey((Object)excludeProtocol)) {
            this._exclusionMap.put(excludeProtocol, new HashSet());
        }
        Set<Integer> ports = this._exclusionMap.get((Object)excludeProtocol);
        ports.add(port);
    }

    public String getBind() {
        return this._bind;
    }

    public void setBind(String bind) {
        this._bind = bind;
    }

    public int getLogWatchFrequency() {
        return this._logWatchFrequency;
    }

    public void setLogWatchFrequency(int logWatchFrequency) {
        this._logWatchFrequency = logWatchFrequency;
    }

    public BundleContext getBundleContext() {
        return this._bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }
}

