/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.plugins;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.log4j.Logger;
import org.apache.qpid.server.configuration.ConfigurationManager;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.IApplicationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ConfigurationPlugin {
    protected static final Logger _logger = Logger.getLogger(ConfigurationPlugin.class);
    private Map<String, ConfigurationPlugin> _pluginConfiguration = new HashMap<String, ConfigurationPlugin>();
    protected Configuration _configuration;

    public abstract String[] getElementsProcessed();

    public void validateConfiguration() throws ConfigurationException {
    }

    public Configuration getConfig() {
        return this._configuration;
    }

    public <C extends ConfigurationPlugin> C getConfiguration(String plugin) {
        return (C)this._pluginConfiguration.get(plugin);
    }

    public void setConfiguration(String path, Configuration configuration) throws ConfigurationException {
        this._configuration = configuration;
        Iterator keys = configuration.getKeys();
        HashSet<String> elements = new HashSet<String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            int elementNameIndex = key.indexOf(".");
            String element = key.trim();
            if (elementNameIndex != -1) {
                element = key.substring(0, elementNameIndex).trim();
            }
            if ((elementNameIndex = element.indexOf("[")) > 0) {
                element = element.substring(0, elementNameIndex).trim();
            }
            elements.add(element);
        }
        for (String tag : this.getElementsProcessed()) {
            int bracketIndex = tag.indexOf("[");
            if (bracketIndex != -1) {
                tag = tag.substring(bracketIndex + 1, tag.length());
            }
            elements.remove(tag);
        }
        if (_logger.isInfoEnabled() && !elements.isEmpty()) {
            _logger.info((Object)("Elements to lookup:" + path));
            for (String tag : elements) {
                _logger.info((Object)("Tag:'" + tag + "'"));
            }
        }
        this.offerRemainingConfigurationToOtherPlugins(path, configuration, elements);
        this.validateConfiguration();
    }

    private void offerRemainingConfigurationToOtherPlugins(String path, Configuration configuration, Set<String> elements) throws ConfigurationException {
        IApplicationRegistry appRegistry = this.safeGetApplicationRegistryInstance();
        if (appRegistry == null) {
            _logger.info((Object)"Cannot offer remaining config to other plugins, can't find app registry");
            return;
        }
        ConfigurationManager configurationManager = appRegistry.getConfigurationManager();
        for (String element : elements) {
            Configuration handled = element.length() == 0 ? configuration : configuration.subset(element);
            String configurationElement = element;
            if (path.length() > 0) {
                configurationElement = path + "." + configurationElement;
            }
            List<ConfigurationPlugin> handlers = configurationManager.getConfigurationPlugins(configurationElement, handled);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("For '" + element + "' found handlers (" + handlers.size() + "):" + handlers));
            }
            for (ConfigurationPlugin plugin : handlers) {
                this._pluginConfiguration.put(plugin.getClass().getName(), plugin);
            }
        }
    }

    private IApplicationRegistry safeGetApplicationRegistryInstance() {
        try {
            return ApplicationRegistry.getInstance();
        }
        catch (IllegalStateException ise) {
            return null;
        }
    }

    public static final void showKeys(Configuration config) {
        if (config.isEmpty()) {
            _logger.info((Object)"Configuration is empty");
        } else {
            Iterator keys = config.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                _logger.info((Object)("Configuration key: " + key));
            }
        }
    }

    protected boolean hasConfiguration() {
        return this._configuration != null;
    }

    protected double getDoubleValue(String property) {
        return this.getDoubleValue(property, 0.0);
    }

    protected double getDoubleValue(String property, double defaultValue) {
        return this._configuration.getDouble(property, defaultValue);
    }

    protected long getLongValue(String property) {
        return this.getLongValue(property, 0L);
    }

    protected long getLongValue(String property, long defaultValue) {
        return this._configuration.getLong(property, defaultValue);
    }

    protected int getIntValue(String property) {
        return this.getIntValue(property, 0);
    }

    protected int getIntValue(String property, int defaultValue) {
        return this._configuration.getInt(property, defaultValue);
    }

    protected String getStringValue(String property) {
        return this.getStringValue(property, null);
    }

    protected String getStringValue(String property, String defaultValue) {
        return this._configuration.getString(property, defaultValue);
    }

    protected boolean getBooleanValue(String property) {
        return this.getBooleanValue(property, false);
    }

    protected boolean getBooleanValue(String property, boolean defaultValue) {
        return this._configuration.getBoolean(property, defaultValue);
    }

    protected List getListValue(String property) {
        return this.getListValue(property, Collections.EMPTY_LIST);
    }

    protected List getListValue(String property, List defaultValue) {
        return this._configuration.getList(property, defaultValue);
    }

    protected boolean contains(String property) {
        return this._configuration.getProperty(property) != null;
    }

    protected void validatePositiveLong(String property) throws ConfigurationException {
        try {
            if (!this.containsPositiveLong(property)) {
                throw new ConfigurationException(this.getClass().getSimpleName() + ": '" + property + "' must be a Positive Long value.");
            }
        }
        catch (Exception e) {
            Throwable last = e;
            if (e instanceof ConversionException) {
                Throwable t = e.getCause();
                while (t != null) {
                    last = t;
                    t = last.getCause();
                }
            }
            throw new ConfigurationException(this.getClass().getSimpleName() + ": unable to configure invalid " + property + ":" + this._configuration.getString(property), last);
        }
    }

    protected boolean containsLong(String property) {
        try {
            this._configuration.getLong(property);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    protected boolean containsPositiveLong(String property) {
        try {
            long value = this._configuration.getLong(property);
            return value > 0L;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    protected boolean containsInt(String property) {
        try {
            this._configuration.getInt(property);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    protected boolean containsBoolean(String property) {
        try {
            this._configuration.getBoolean(property);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public void addConfiguration(ConfigurationPlugin configuration) {
        if (configuration == null) {
            return;
        }
        for (Map.Entry<String, ConfigurationPlugin> newPlugins : configuration._pluginConfiguration.entrySet()) {
            String key = newPlugins.getKey();
            ConfigurationPlugin config = newPlugins.getValue();
            if (this._pluginConfiguration.containsKey(key)) {
                this._pluginConfiguration.get(key).mergeConfiguration(config);
                continue;
            }
            this._pluginConfiguration.put(key, config);
        }
        String key = configuration.getClass().getName();
        if (this._pluginConfiguration.containsKey(key)) {
            this._pluginConfiguration.get(key).mergeConfiguration(configuration);
        } else if (configuration.getClass() == this.getClass()) {
            this.mergeConfiguration(configuration);
        } else {
            this._pluginConfiguration.put(key, configuration);
        }
    }

    protected void mergeConfiguration(ConfigurationPlugin configuration) {
        this._configuration = configuration.getConfig();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n").append(this.getClass().getSimpleName());
        sb.append("=[ (").append(this.formatToString()).append(")");
        for (Map.Entry<String, ConfigurationPlugin> item : this._pluginConfiguration.entrySet()) {
            sb.append("\n").append(item.getValue());
        }
        sb.append("]\n");
        return sb.toString();
    }

    public String formatToString() {
        return super.toString();
    }
}

